package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListGatewaysPacketStat invokes the linkwan.ListGatewaysPacketStat API synchronously
func (client *Client) ListGatewaysPacketStat(request *ListGatewaysPacketStatRequest) (response *ListGatewaysPacketStatResponse, err error) {
	response = CreateListGatewaysPacketStatResponse()
	err = client.DoAction(request, response)
	return
}

// ListGatewaysPacketStatWithChan invokes the linkwan.ListGatewaysPacketStat API asynchronously
func (client *Client) ListGatewaysPacketStatWithChan(request *ListGatewaysPacketStatRequest) (<-chan *ListGatewaysPacketStatResponse, <-chan error) {
	responseChan := make(chan *ListGatewaysPacketStatResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListGatewaysPacketStat(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListGatewaysPacketStatWithCallback invokes the linkwan.ListGatewaysPacketStat API asynchronously
func (client *Client) ListGatewaysPacketStatWithCallback(request *ListGatewaysPacketStatRequest, callback func(response *ListGatewaysPacketStatResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListGatewaysPacketStatResponse
		var err error
		defer close(result)
		response, err = client.ListGatewaysPacketStat(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListGatewaysPacketStatRequest is the request struct for api ListGatewaysPacketStat
type ListGatewaysPacketStatRequest struct {
	*requests.RpcRequest
	EndMillis     requests.Integer `position:"Query" name:"EndMillis"`
	GwEuiList     *[]string        `position:"Query" name:"GwEuiList"  type:"Repeated"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
	BeginMillis   requests.Integer `position:"Query" name:"BeginMillis"`
}

// ListGatewaysPacketStatResponse is the response struct for api ListGatewaysPacketStat
type ListGatewaysPacketStatResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"RequestId" xml:"RequestId"`
	Success   bool                `json:"Success" xml:"Success"`
	Data      []GatewayPacketStat `json:"Data" xml:"Data"`
}

// CreateListGatewaysPacketStatRequest creates a request to invoke ListGatewaysPacketStat API
func CreateListGatewaysPacketStatRequest() (request *ListGatewaysPacketStatRequest) {
	request = &ListGatewaysPacketStatRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListGatewaysPacketStat", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListGatewaysPacketStatResponse creates a response to parse from ListGatewaysPacketStat response
func CreateListGatewaysPacketStatResponse() (response *ListGatewaysPacketStatResponse) {
	response = &ListGatewaysPacketStatResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
