package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitGatewayLocalConfigAddingTask invokes the linkwan.SubmitGatewayLocalConfigAddingTask API synchronously
func (client *Client) SubmitGatewayLocalConfigAddingTask(request *SubmitGatewayLocalConfigAddingTaskRequest) (response *SubmitGatewayLocalConfigAddingTaskResponse, err error) {
	response = CreateSubmitGatewayLocalConfigAddingTaskResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitGatewayLocalConfigAddingTaskWithChan invokes the linkwan.SubmitGatewayLocalConfigAddingTask API asynchronously
func (client *Client) SubmitGatewayLocalConfigAddingTaskWithChan(request *SubmitGatewayLocalConfigAddingTaskRequest) (<-chan *SubmitGatewayLocalConfigAddingTaskResponse, <-chan error) {
	responseChan := make(chan *SubmitGatewayLocalConfigAddingTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitGatewayLocalConfigAddingTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitGatewayLocalConfigAddingTaskWithCallback invokes the linkwan.SubmitGatewayLocalConfigAddingTask API asynchronously
func (client *Client) SubmitGatewayLocalConfigAddingTaskWithCallback(request *SubmitGatewayLocalConfigAddingTaskRequest, callback func(response *SubmitGatewayLocalConfigAddingTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitGatewayLocalConfigAddingTaskResponse
		var err error
		defer close(result)
		response, err = client.SubmitGatewayLocalConfigAddingTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitGatewayLocalConfigAddingTaskRequest is the request struct for api SubmitGatewayLocalConfigAddingTask
type SubmitGatewayLocalConfigAddingTaskRequest struct {
	*requests.RpcRequest
	Freq        requests.Integer `position:"Query" name:"Freq"`
	Datr        requests.Integer `position:"Query" name:"Datr"`
	D2dKey      string           `position:"Query" name:"D2dKey"`
	GwEui       string           `position:"Query" name:"GwEui"`
	D2dAddr     string           `position:"Query" name:"D2dAddr"`
	ApiProduct  string           `position:"Body" name:"ApiProduct"`
	ApiRevision string           `position:"Body" name:"ApiRevision"`
}

// SubmitGatewayLocalConfigAddingTaskResponse is the response struct for api SubmitGatewayLocalConfigAddingTask
type SubmitGatewayLocalConfigAddingTaskResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         int64  `json:"Data" xml:"Data"`
}

// CreateSubmitGatewayLocalConfigAddingTaskRequest creates a request to invoke SubmitGatewayLocalConfigAddingTask API
func CreateSubmitGatewayLocalConfigAddingTaskRequest() (request *SubmitGatewayLocalConfigAddingTaskRequest) {
	request = &SubmitGatewayLocalConfigAddingTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "SubmitGatewayLocalConfigAddingTask", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitGatewayLocalConfigAddingTaskResponse creates a response to parse from SubmitGatewayLocalConfigAddingTask response
func CreateSubmitGatewayLocalConfigAddingTaskResponse() (response *SubmitGatewayLocalConfigAddingTaskResponse) {
	response = &SubmitGatewayLocalConfigAddingTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
