package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddTrancodeSEI invokes the live.AddTrancodeSEI API synchronously
func (client *Client) AddTrancodeSEI(request *AddTrancodeSEIRequest) (response *AddTrancodeSEIResponse, err error) {
	response = CreateAddTrancodeSEIResponse()
	err = client.DoAction(request, response)
	return
}

// AddTrancodeSEIWithChan invokes the live.AddTrancodeSEI API asynchronously
func (client *Client) AddTrancodeSEIWithChan(request *AddTrancodeSEIRequest) (<-chan *AddTrancodeSEIResponse, <-chan error) {
	responseChan := make(chan *AddTrancodeSEIResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddTrancodeSEI(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddTrancodeSEIWithCallback invokes the live.AddTrancodeSEI API asynchronously
func (client *Client) AddTrancodeSEIWithCallback(request *AddTrancodeSEIRequest, callback func(response *AddTrancodeSEIResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddTrancodeSEIResponse
		var err error
		defer close(result)
		response, err = client.AddTrancodeSEI(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddTrancodeSEIRequest is the request struct for api AddTrancodeSEI
type AddTrancodeSEIRequest struct {
	*requests.RpcRequest
	Pattern    string           `position:"Query" name:"Pattern"`
	AppName    string           `position:"Query" name:"AppName"`
	Repeat     requests.Integer `position:"Query" name:"Repeat"`
	Text       string           `position:"Query" name:"Text"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Delay      requests.Integer `position:"Query" name:"Delay"`
}

// AddTrancodeSEIResponse is the response struct for api AddTrancodeSEI
type AddTrancodeSEIResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddTrancodeSEIRequest creates a request to invoke AddTrancodeSEI API
func CreateAddTrancodeSEIRequest() (request *AddTrancodeSEIRequest) {
	request = &AddTrancodeSEIRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddTrancodeSEI", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddTrancodeSEIResponse creates a response to parse from AddTrancodeSEI response
func CreateAddTrancodeSEIResponse() (response *AddTrancodeSEIResponse) {
	response = &AddTrancodeSEIResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
