package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveASRConfig invokes the live.DeleteLiveASRConfig API synchronously
func (client *Client) DeleteLiveASRConfig(request *DeleteLiveASRConfigRequest) (response *DeleteLiveASRConfigResponse, err error) {
	response = CreateDeleteLiveASRConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveASRConfigWithChan invokes the live.DeleteLiveASRConfig API asynchronously
func (client *Client) DeleteLiveASRConfigWithChan(request *DeleteLiveASRConfigRequest) (<-chan *DeleteLiveASRConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveASRConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveASRConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveASRConfigWithCallback invokes the live.DeleteLiveASRConfig API asynchronously
func (client *Client) DeleteLiveASRConfigWithCallback(request *DeleteLiveASRConfigRequest, callback func(response *DeleteLiveASRConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveASRConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveASRConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveASRConfigRequest is the request struct for api DeleteLiveASRConfig
type DeleteLiveASRConfigRequest struct {
	*requests.RpcRequest
	AppName    string           `position:"Query" name:"AppName"`
	StreamName string           `position:"Query" name:"StreamName"`
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteLiveASRConfigResponse is the response struct for api DeleteLiveASRConfig
type DeleteLiveASRConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveASRConfigRequest creates a request to invoke DeleteLiveASRConfig API
func CreateDeleteLiveASRConfigRequest() (request *DeleteLiveASRConfigRequest) {
	request = &DeleteLiveASRConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveASRConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveASRConfigResponse creates a response to parse from DeleteLiveASRConfig response
func CreateDeleteLiveASRConfigResponse() (response *DeleteLiveASRConfigResponse) {
	response = &DeleteLiveASRConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
