package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainConfigs invokes the live.DescribeLiveDomainConfigs API synchronously
func (client *Client) DescribeLiveDomainConfigs(request *DescribeLiveDomainConfigsRequest) (response *DescribeLiveDomainConfigsResponse, err error) {
	response = CreateDescribeLiveDomainConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainConfigsWithChan invokes the live.DescribeLiveDomainConfigs API asynchronously
func (client *Client) DescribeLiveDomainConfigsWithChan(request *DescribeLiveDomainConfigsRequest) (<-chan *DescribeLiveDomainConfigsResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainConfigsWithCallback invokes the live.DescribeLiveDomainConfigs API asynchronously
func (client *Client) DescribeLiveDomainConfigsWithCallback(request *DescribeLiveDomainConfigsRequest, callback func(response *DescribeLiveDomainConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainConfigsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainConfigsRequest is the request struct for api DescribeLiveDomainConfigs
type DescribeLiveDomainConfigsRequest struct {
	*requests.RpcRequest
	FunctionNames string           `position:"Query" name:"FunctionNames"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// DescribeLiveDomainConfigsResponse is the response struct for api DescribeLiveDomainConfigs
type DescribeLiveDomainConfigsResponse struct {
	*responses.BaseResponse
	RequestId     string                                   `json:"RequestId" xml:"RequestId"`
	DomainConfigs DomainConfigsInDescribeLiveDomainConfigs `json:"DomainConfigs" xml:"DomainConfigs"`
}

// CreateDescribeLiveDomainConfigsRequest creates a request to invoke DescribeLiveDomainConfigs API
func CreateDescribeLiveDomainConfigsRequest() (request *DescribeLiveDomainConfigsRequest) {
	request = &DescribeLiveDomainConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainConfigs", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainConfigsResponse creates a response to parse from DescribeLiveDomainConfigs response
func CreateDescribeLiveDomainConfigsResponse() (response *DescribeLiveDomainConfigsResponse) {
	response = &DescribeLiveDomainConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
