package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveUserTags invokes the live.DescribeLiveUserTags API synchronously
func (client *Client) DescribeLiveUserTags(request *DescribeLiveUserTagsRequest) (response *DescribeLiveUserTagsResponse, err error) {
	response = CreateDescribeLiveUserTagsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveUserTagsWithChan invokes the live.DescribeLiveUserTags API asynchronously
func (client *Client) DescribeLiveUserTagsWithChan(request *DescribeLiveUserTagsRequest) (<-chan *DescribeLiveUserTagsResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveUserTagsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveUserTags(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveUserTagsWithCallback invokes the live.DescribeLiveUserTags API asynchronously
func (client *Client) DescribeLiveUserTagsWithCallback(request *DescribeLiveUserTagsRequest, callback func(response *DescribeLiveUserTagsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveUserTagsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveUserTags(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveUserTagsRequest is the request struct for api DescribeLiveUserTags
type DescribeLiveUserTagsRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveUserTagsResponse is the response struct for api DescribeLiveUserTags
type DescribeLiveUserTagsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Tags      []Tag  `json:"Tags" xml:"Tags"`
}

// CreateDescribeLiveUserTagsRequest creates a request to invoke DescribeLiveUserTags API
func CreateDescribeLiveUserTagsRequest() (request *DescribeLiveUserTagsRequest) {
	request = &DescribeLiveUserTagsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveUserTags", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveUserTagsResponse creates a response to parse from DescribeLiveUserTags response
func CreateDescribeLiveUserTagsResponse() (response *DescribeLiveUserTagsResponse) {
	response = &DescribeLiveUserTagsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
