package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateLiveASRConfig invokes the live.UpdateLiveASRConfig API synchronously
func (client *Client) UpdateLiveASRConfig(request *UpdateLiveASRConfigRequest) (response *UpdateLiveASRConfigResponse, err error) {
	response = CreateUpdateLiveASRConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateLiveASRConfigWithChan invokes the live.UpdateLiveASRConfig API asynchronously
func (client *Client) UpdateLiveASRConfigWithChan(request *UpdateLiveASRConfigRequest) (<-chan *UpdateLiveASRConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateLiveASRConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateLiveASRConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateLiveASRConfigWithCallback invokes the live.UpdateLiveASRConfig API asynchronously
func (client *Client) UpdateLiveASRConfigWithCallback(request *UpdateLiveASRConfigRequest, callback func(response *UpdateLiveASRConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateLiveASRConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateLiveASRConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateLiveASRConfigRequest is the request struct for api UpdateLiveASRConfig
type UpdateLiveASRConfigRequest struct {
	*requests.RpcRequest
	AppName         string           `position:"Query" name:"AppName"`
	MnsTopic        string           `position:"Query" name:"MnsTopic"`
	StreamName      string           `position:"Query" name:"StreamName"`
	Period          requests.Integer `position:"Query" name:"Period"`
	DomainName      string           `position:"Query" name:"DomainName"`
	HttpCallbackURL string           `position:"Query" name:"HttpCallbackURL"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	MnsRegion       string           `position:"Query" name:"MnsRegion"`
}

// UpdateLiveASRConfigResponse is the response struct for api UpdateLiveASRConfig
type UpdateLiveASRConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateLiveASRConfigRequest creates a request to invoke UpdateLiveASRConfig API
func CreateUpdateLiveASRConfigRequest() (request *UpdateLiveASRConfigRequest) {
	request = &UpdateLiveASRConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "UpdateLiveASRConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateLiveASRConfigResponse creates a response to parse from UpdateLiveASRConfig response
func CreateUpdateLiveASRConfigResponse() (response *UpdateLiveASRConfigResponse) {
	response = &UpdateLiveASRConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
