package location

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEndpoint invokes the location.DescribeEndpoint API synchronously
// api document: https://help.aliyun.com/api/location/describeendpoint.html
func (client *Client) DescribeEndpoint(request *DescribeEndpointRequest) (response *DescribeEndpointResponse, err error) {
	response = CreateDescribeEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEndpointWithChan invokes the location.DescribeEndpoint API asynchronously
// api document: https://help.aliyun.com/api/location/describeendpoint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEndpointWithChan(request *DescribeEndpointRequest) (<-chan *DescribeEndpointResponse, <-chan error) {
	responseChan := make(chan *DescribeEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEndpointWithCallback invokes the location.DescribeEndpoint API asynchronously
// api document: https://help.aliyun.com/api/location/describeendpoint.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeEndpointWithCallback(request *DescribeEndpointRequest, callback func(response *DescribeEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEndpointResponse
		var err error
		defer close(result)
		response, err = client.DescribeEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEndpointRequest is the request struct for api DescribeEndpoint
type DescribeEndpointRequest struct {
	*requests.RpcRequest
	Password    string `position:"Query" name:"Password"`
	ServiceCode string `position:"Query" name:"ServiceCode"`
	Id          string `position:"Query" name:"Id"`
}

// DescribeEndpointResponse is the response struct for api DescribeEndpoint
type DescribeEndpointResponse struct {
	*responses.BaseResponse
	RequestId   string                      `json:"RequestId" xml:"RequestId"`
	Endpoint    string                      `json:"Endpoint" xml:"Endpoint"`
	Id          string                      `json:"Id" xml:"Id"`
	Namespace   string                      `json:"Namespace" xml:"Namespace"`
	SerivceCode string                      `json:"SerivceCode" xml:"SerivceCode"`
	Type        string                      `json:"Type" xml:"Type"`
	Protocols   ProtocolsInDescribeEndpoint `json:"Protocols" xml:"Protocols"`
}

// CreateDescribeEndpointRequest creates a request to invoke DescribeEndpoint API
func CreateDescribeEndpointRequest() (request *DescribeEndpointRequest) {
	request = &DescribeEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Location", "2015-06-12", "DescribeEndpoint", "location", "openAPI")
	return
}

// CreateDescribeEndpointResponse creates a response to parse from DescribeEndpoint response
func CreateDescribeEndpointResponse() (response *DescribeEndpointResponse) {
	response = &DescribeEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
