package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAlarmRule invokes the mse.CreateAlarmRule API synchronously
func (client *Client) CreateAlarmRule(request *CreateAlarmRuleRequest) (response *CreateAlarmRuleResponse, err error) {
	response = CreateCreateAlarmRuleResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAlarmRuleWithChan invokes the mse.CreateAlarmRule API asynchronously
func (client *Client) CreateAlarmRuleWithChan(request *CreateAlarmRuleRequest) (<-chan *CreateAlarmRuleResponse, <-chan error) {
	responseChan := make(chan *CreateAlarmRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAlarmRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAlarmRuleWithCallback invokes the mse.CreateAlarmRule API asynchronously
func (client *Client) CreateAlarmRuleWithCallback(request *CreateAlarmRuleRequest, callback func(response *CreateAlarmRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAlarmRuleResponse
		var err error
		defer close(result)
		response, err = client.CreateAlarmRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAlarmRuleRequest is the request struct for api CreateAlarmRule
type CreateAlarmRuleRequest struct {
	*requests.RpcRequest
	NValue          requests.Integer `position:"Query" name:"NValue"`
	AlarmItem       string           `position:"Query" name:"AlarmItem"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	Operator        string           `position:"Query" name:"Operator"`
	AlarmAliasName  string           `position:"Query" name:"AlarmAliasName"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	ContactGroupIds string           `position:"Query" name:"ContactGroupIds"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
	AlertWay        string           `position:"Query" name:"AlertWay"`
	Aggregates      string           `position:"Query" name:"Aggregates"`
	Value           requests.Float   `position:"Query" name:"Value"`
}

// CreateAlarmRuleResponse is the response struct for api CreateAlarmRule
type CreateAlarmRuleResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateCreateAlarmRuleRequest creates a request to invoke CreateAlarmRule API
func CreateCreateAlarmRuleRequest() (request *CreateAlarmRuleRequest) {
	request = &CreateAlarmRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "CreateAlarmRule", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateAlarmRuleResponse creates a response to parse from CreateAlarmRule response
func CreateCreateAlarmRuleResponse() (response *CreateAlarmRuleResponse) {
	response = &CreateAlarmRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
