package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMCJobList invokes the mts.QueryMCJobList API synchronously
func (client *Client) QueryMCJobList(request *QueryMCJobListRequest) (response *QueryMCJobListResponse, err error) {
	response = CreateQueryMCJobListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMCJobListWithChan invokes the mts.QueryMCJobList API asynchronously
func (client *Client) QueryMCJobListWithChan(request *QueryMCJobListRequest) (<-chan *QueryMCJobListResponse, <-chan error) {
	responseChan := make(chan *QueryMCJobListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMCJobList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMCJobListWithCallback invokes the mts.QueryMCJobList API asynchronously
func (client *Client) QueryMCJobListWithCallback(request *QueryMCJobListRequest, callback func(response *QueryMCJobListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMCJobListResponse
		var err error
		defer close(result)
		response, err = client.QueryMCJobList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMCJobListRequest is the request struct for api QueryMCJobList
type QueryMCJobListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NextPageToken              string           `position:"Query" name:"NextPageToken"`
	StartOfJobCreatedTimeRange string           `position:"Query" name:"StartOfJobCreatedTimeRange"`
	State                      string           `position:"Query" name:"State"`
	EndOfJobCreatedTimeRange   string           `position:"Query" name:"EndOfJobCreatedTimeRange"`
	ResourceOwnerAccount       string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount               string           `position:"Query" name:"OwnerAccount"`
	MaximumPageSize            requests.Integer `position:"Query" name:"MaximumPageSize"`
	OwnerId                    requests.Integer `position:"Query" name:"OwnerId"`
	PipelineId                 string           `position:"Query" name:"PipelineId"`
	JobIds                     string           `position:"Query" name:"JobIds"`
}

// QueryMCJobListResponse is the response struct for api QueryMCJobList
type QueryMCJobListResponse struct {
	*responses.BaseResponse
	RequestId     string                      `json:"RequestId" xml:"RequestId"`
	NextPageToken string                      `json:"NextPageToken" xml:"NextPageToken"`
	NonExistIds   NonExistIdsInQueryMCJobList `json:"NonExistIds" xml:"NonExistIds"`
	JobList       JobListInQueryMCJobList     `json:"JobList" xml:"JobList"`
}

// CreateQueryMCJobListRequest creates a request to invoke QueryMCJobList API
func CreateQueryMCJobListRequest() (request *QueryMCJobListRequest) {
	request = &QueryMCJobListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryMCJobList", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryMCJobListResponse creates a response to parse from QueryMCJobList response
func CreateQueryMCJobListResponse() (response *QueryMCJobListResponse) {
	response = &QueryMCJobListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
