package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryVideoQualityJob invokes the mts.QueryVideoQualityJob API synchronously
func (client *Client) QueryVideoQualityJob(request *QueryVideoQualityJobRequest) (response *QueryVideoQualityJobResponse, err error) {
	response = CreateQueryVideoQualityJobResponse()
	err = client.DoAction(request, response)
	return
}

// QueryVideoQualityJobWithChan invokes the mts.QueryVideoQualityJob API asynchronously
func (client *Client) QueryVideoQualityJobWithChan(request *QueryVideoQualityJobRequest) (<-chan *QueryVideoQualityJobResponse, <-chan error) {
	responseChan := make(chan *QueryVideoQualityJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryVideoQualityJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryVideoQualityJobWithCallback invokes the mts.QueryVideoQualityJob API asynchronously
func (client *Client) QueryVideoQualityJobWithCallback(request *QueryVideoQualityJobRequest, callback func(response *QueryVideoQualityJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryVideoQualityJobResponse
		var err error
		defer close(result)
		response, err = client.QueryVideoQualityJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryVideoQualityJobRequest is the request struct for api QueryVideoQualityJob
type QueryVideoQualityJobRequest struct {
	*requests.RpcRequest
	UserId requests.Integer `position:"Query" name:"UserId"`
	JobId  string           `position:"Query" name:"JobId"`
}

// QueryVideoQualityJobResponse is the response struct for api QueryVideoQualityJob
type QueryVideoQualityJobResponse struct {
	*responses.BaseResponse
	Message   string                    `json:"Message" xml:"Message"`
	RequestId string                    `json:"RequestId" xml:"RequestId"`
	Code      string                    `json:"Code" xml:"Code"`
	Job       JobInQueryVideoQualityJob `json:"Job" xml:"Job"`
}

// CreateQueryVideoQualityJobRequest creates a request to invoke QueryVideoQualityJob API
func CreateQueryVideoQualityJobRequest() (request *QueryVideoQualityJobRequest) {
	request = &QueryVideoQualityJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "QueryVideoQualityJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryVideoQualityJobResponse creates a response to parse from QueryVideoQualityJob response
func CreateQueryVideoQualityJobResponse() (response *QueryVideoQualityJobResponse) {
	response = &QueryVideoQualityJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
