package netana

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNetworkAnalyticsNetQuality invokes the netana.DescribeNetworkAnalyticsNetQuality API synchronously
// api document: https://help.aliyun.com/api/netana/describenetworkanalyticsnetquality.html
func (client *Client) DescribeNetworkAnalyticsNetQuality(request *DescribeNetworkAnalyticsNetQualityRequest) (response *DescribeNetworkAnalyticsNetQualityResponse, err error) {
	response = CreateDescribeNetworkAnalyticsNetQualityResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNetworkAnalyticsNetQualityWithChan invokes the netana.DescribeNetworkAnalyticsNetQuality API asynchronously
// api document: https://help.aliyun.com/api/netana/describenetworkanalyticsnetquality.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkAnalyticsNetQualityWithChan(request *DescribeNetworkAnalyticsNetQualityRequest) (<-chan *DescribeNetworkAnalyticsNetQualityResponse, <-chan error) {
	responseChan := make(chan *DescribeNetworkAnalyticsNetQualityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNetworkAnalyticsNetQuality(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNetworkAnalyticsNetQualityWithCallback invokes the netana.DescribeNetworkAnalyticsNetQuality API asynchronously
// api document: https://help.aliyun.com/api/netana/describenetworkanalyticsnetquality.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeNetworkAnalyticsNetQualityWithCallback(request *DescribeNetworkAnalyticsNetQualityRequest, callback func(response *DescribeNetworkAnalyticsNetQualityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNetworkAnalyticsNetQualityResponse
		var err error
		defer close(result)
		response, err = client.DescribeNetworkAnalyticsNetQuality(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNetworkAnalyticsNetQualityRequest is the request struct for api DescribeNetworkAnalyticsNetQuality
type DescribeNetworkAnalyticsNetQualityRequest struct {
	*requests.RpcRequest
	Country              string           `position:"Query" name:"Country"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Period               string           `position:"Query" name:"Period"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	StartTime            string           `position:"Query" name:"StartTime"`
	PageNumber           string           `position:"Query" name:"PageNumber"`
	Carrier              string           `position:"Query" name:"Carrier"`
	Province             string           `position:"Query" name:"Province"`
	Grade                string           `position:"Query" name:"Grade"`
	PageSize             string           `position:"Query" name:"PageSize"`
}

// DescribeNetworkAnalyticsNetQualityResponse is the response struct for api DescribeNetworkAnalyticsNetQuality
type DescribeNetworkAnalyticsNetQualityResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	TotalCount   int          `json:"TotalCount" xml:"TotalCount"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	NetQualities NetQualities `json:"NetQualities" xml:"NetQualities"`
}

// CreateDescribeNetworkAnalyticsNetQualityRequest creates a request to invoke DescribeNetworkAnalyticsNetQuality API
func CreateDescribeNetworkAnalyticsNetQualityRequest() (request *DescribeNetworkAnalyticsNetQualityRequest) {
	request = &DescribeNetworkAnalyticsNetQualityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Netana", "2018-10-18", "DescribeNetworkAnalyticsNetQuality", "Netana", "openAPI")
	return
}

// CreateDescribeNetworkAnalyticsNetQualityResponse creates a response to parse from DescribeNetworkAnalyticsNetQuality response
func CreateDescribeNetworkAnalyticsNetQualityResponse() (response *DescribeNetworkAnalyticsNetQualityResponse) {
	response = &DescribeNetworkAnalyticsNetQualityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
