package oam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddRoleToRole invokes the oam.AddRoleToRole API synchronously
// api document: https://help.aliyun.com/api/oam/addroletorole.html
func (client *Client) AddRoleToRole(request *AddRoleToRoleRequest) (response *AddRoleToRoleResponse, err error) {
	response = CreateAddRoleToRoleResponse()
	err = client.DoAction(request, response)
	return
}

// AddRoleToRoleWithChan invokes the oam.AddRoleToRole API asynchronously
// api document: https://help.aliyun.com/api/oam/addroletorole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddRoleToRoleWithChan(request *AddRoleToRoleRequest) (<-chan *AddRoleToRoleResponse, <-chan error) {
	responseChan := make(chan *AddRoleToRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddRoleToRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddRoleToRoleWithCallback invokes the oam.AddRoleToRole API asynchronously
// api document: https://help.aliyun.com/api/oam/addroletorole.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AddRoleToRoleWithCallback(request *AddRoleToRoleRequest, callback func(response *AddRoleToRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddRoleToRoleResponse
		var err error
		defer close(result)
		response, err = client.AddRoleToRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddRoleToRoleRequest is the request struct for api AddRoleToRole
type AddRoleToRoleRequest struct {
	*requests.RpcRequest
	RoleName     string `position:"Query" name:"RoleName"`
	BaseRoleName string `position:"Query" name:"BaseRoleName"`
}

// AddRoleToRoleResponse is the response struct for api AddRoleToRole
type AddRoleToRoleResponse struct {
	*responses.BaseResponse
	Code    string `json:"Code" xml:"Code"`
	Message string `json:"Message" xml:"Message"`
}

// CreateAddRoleToRoleRequest creates a request to invoke AddRoleToRole API
func CreateAddRoleToRoleRequest() (request *AddRoleToRoleRequest) {
	request = &AddRoleToRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oam", "2017-01-01", "AddRoleToRole", "", "")
	request.Method = requests.POST
	return
}

// CreateAddRoleToRoleResponse creates a response to parse from AddRoleToRole response
func CreateAddRoleToRoleResponse() (response *AddRoleToRoleResponse) {
	response = &AddRoleToRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
