package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsGroupDelete invokes the ons.OnsGroupDelete API synchronously
func (client *Client) OnsGroupDelete(request *OnsGroupDeleteRequest) (response *OnsGroupDeleteResponse, err error) {
	response = CreateOnsGroupDeleteResponse()
	err = client.DoAction(request, response)
	return
}

// OnsGroupDeleteWithChan invokes the ons.OnsGroupDelete API asynchronously
func (client *Client) OnsGroupDeleteWithChan(request *OnsGroupDeleteRequest) (<-chan *OnsGroupDeleteResponse, <-chan error) {
	responseChan := make(chan *OnsGroupDeleteResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsGroupDelete(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsGroupDeleteWithCallback invokes the ons.OnsGroupDelete API asynchronously
func (client *Client) OnsGroupDeleteWithCallback(request *OnsGroupDeleteRequest, callback func(response *OnsGroupDeleteResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsGroupDeleteResponse
		var err error
		defer close(result)
		response, err = client.OnsGroupDelete(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsGroupDeleteRequest is the request struct for api OnsGroupDelete
type OnsGroupDeleteRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// OnsGroupDeleteResponse is the response struct for api OnsGroupDelete
type OnsGroupDeleteResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
}

// CreateOnsGroupDeleteRequest creates a request to invoke OnsGroupDelete API
func CreateOnsGroupDeleteRequest() (request *OnsGroupDeleteRequest) {
	request = &OnsGroupDeleteRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsGroupDelete", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsGroupDeleteResponse creates a response to parse from OnsGroupDelete response
func CreateOnsGroupDeleteResponse() (response *OnsGroupDeleteResponse) {
	response = &OnsGroupDeleteResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
