package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAllDatabases invokes the openanalytics_open.GetAllDatabases API synchronously
func (client *Client) GetAllDatabases(request *GetAllDatabasesRequest) (response *GetAllDatabasesResponse, err error) {
	response = CreateGetAllDatabasesResponse()
	err = client.DoAction(request, response)
	return
}

// GetAllDatabasesWithChan invokes the openanalytics_open.GetAllDatabases API asynchronously
func (client *Client) GetAllDatabasesWithChan(request *GetAllDatabasesRequest) (<-chan *GetAllDatabasesResponse, <-chan error) {
	responseChan := make(chan *GetAllDatabasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAllDatabases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAllDatabasesWithCallback invokes the openanalytics_open.GetAllDatabases API asynchronously
func (client *Client) GetAllDatabasesWithCallback(request *GetAllDatabasesRequest, callback func(response *GetAllDatabasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAllDatabasesResponse
		var err error
		defer close(result)
		response, err = client.GetAllDatabases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAllDatabasesRequest is the request struct for api GetAllDatabases
type GetAllDatabasesRequest struct {
	*requests.RpcRequest
}

// GetAllDatabasesResponse is the response struct for api GetAllDatabases
type GetAllDatabasesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Message   string   `json:"Message" xml:"Message"`
	Code      string   `json:"Code" xml:"Code"`
	Success   bool     `json:"Success" xml:"Success"`
	Data      []string `json:"Data" xml:"Data"`
}

// CreateGetAllDatabasesRequest creates a request to invoke GetAllDatabases API
func CreateGetAllDatabasesRequest() (request *GetAllDatabasesRequest) {
	request = &GetAllDatabasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "GetAllDatabases", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAllDatabasesResponse creates a response to parse from GetAllDatabases response
func CreateGetAllDatabasesResponse() (response *GetAllDatabasesResponse) {
	response = &GetAllDatabasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
