package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccountList invokes the openanalytics_open.QueryAccountList API synchronously
func (client *Client) QueryAccountList(request *QueryAccountListRequest) (response *QueryAccountListResponse, err error) {
	response = CreateQueryAccountListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccountListWithChan invokes the openanalytics_open.QueryAccountList API asynchronously
func (client *Client) QueryAccountListWithChan(request *QueryAccountListRequest) (<-chan *QueryAccountListResponse, <-chan error) {
	responseChan := make(chan *QueryAccountListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccountList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccountListWithCallback invokes the openanalytics_open.QueryAccountList API asynchronously
func (client *Client) QueryAccountListWithCallback(request *QueryAccountListRequest, callback func(response *QueryAccountListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccountListResponse
		var err error
		defer close(result)
		response, err = client.QueryAccountList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccountListRequest is the request struct for api QueryAccountList
type QueryAccountListRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
}

// QueryAccountListResponse is the response struct for api QueryAccountList
type QueryAccountListResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	RegionId   string     `json:"RegionId" xml:"RegionId"`
	PageSize   int        `json:"PageSize" xml:"PageSize"`
	PageNumber int        `json:"PageNumber" xml:"PageNumber"`
	TotalCount int        `json:"TotalCount" xml:"TotalCount"`
	Data       []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryAccountListRequest creates a request to invoke QueryAccountList API
func CreateQueryAccountListRequest() (request *QueryAccountListRequest) {
	request = &QueryAccountListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2018-06-19", "QueryAccountList", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryAccountListResponse creates a response to parse from QueryAccountList response
func CreateQueryAccountListResponse() (response *QueryAccountListResponse) {
	response = &QueryAccountListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
