package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListIntents invokes the outboundbot.ListIntents API synchronously
func (client *Client) ListIntents(request *ListIntentsRequest) (response *ListIntentsResponse, err error) {
	response = CreateListIntentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListIntentsWithChan invokes the outboundbot.ListIntents API asynchronously
func (client *Client) ListIntentsWithChan(request *ListIntentsRequest) (<-chan *ListIntentsResponse, <-chan error) {
	responseChan := make(chan *ListIntentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListIntents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListIntentsWithCallback invokes the outboundbot.ListIntents API asynchronously
func (client *Client) ListIntentsWithCallback(request *ListIntentsRequest, callback func(response *ListIntentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListIntentsResponse
		var err error
		defer close(result)
		response, err = client.ListIntents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListIntentsRequest is the request struct for api ListIntents
type ListIntentsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	ScriptId   string           `position:"Query" name:"ScriptId"`
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Keyword    string           `position:"Query" name:"Keyword"`
}

// ListIntentsResponse is the response struct for api ListIntents
type ListIntentsResponse struct {
	*responses.BaseResponse
	Code           string  `json:"Code" xml:"Code"`
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string  `json:"Message" xml:"Message"`
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Success        bool    `json:"Success" xml:"Success"`
	Intents        Intents `json:"Intents" xml:"Intents"`
}

// CreateListIntentsRequest creates a request to invoke ListIntents API
func CreateListIntentsRequest() (request *ListIntentsRequest) {
	request = &ListIntentsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "ListIntents", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListIntentsResponse creates a response to parse from ListIntents response
func CreateListIntentsResponse() (response *ListIntentsResponse) {
	response = &ListIntentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
