package petadata

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSecurityIPs invokes the petadata.DescribeSecurityIPs API synchronously
// api document: https://help.aliyun.com/api/petadata/describesecurityips.html
func (client *Client) DescribeSecurityIPs(request *DescribeSecurityIPsRequest) (response *DescribeSecurityIPsResponse, err error) {
	response = CreateDescribeSecurityIPsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSecurityIPsWithChan invokes the petadata.DescribeSecurityIPs API asynchronously
// api document: https://help.aliyun.com/api/petadata/describesecurityips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSecurityIPsWithChan(request *DescribeSecurityIPsRequest) (<-chan *DescribeSecurityIPsResponse, <-chan error) {
	responseChan := make(chan *DescribeSecurityIPsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSecurityIPs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSecurityIPsWithCallback invokes the petadata.DescribeSecurityIPs API asynchronously
// api document: https://help.aliyun.com/api/petadata/describesecurityips.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSecurityIPsWithCallback(request *DescribeSecurityIPsRequest, callback func(response *DescribeSecurityIPsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSecurityIPsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSecurityIPs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSecurityIPsRequest is the request struct for api DescribeSecurityIPs
type DescribeSecurityIPsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeSecurityIPsResponse is the response struct for api DescribeSecurityIPs
type DescribeSecurityIPsResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	InstanceId     string      `json:"InstanceId" xml:"InstanceId"`
	SecurityIPList string      `json:"SecurityIPList" xml:"SecurityIPList"`
	SecurityIPs    SecurityIPs `json:"SecurityIPs" xml:"SecurityIPs"`
}

// CreateDescribeSecurityIPsRequest creates a request to invoke DescribeSecurityIPs API
func CreateDescribeSecurityIPsRequest() (request *DescribeSecurityIPsRequest) {
	request = &DescribeSecurityIPsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PetaData", "2016-01-01", "DescribeSecurityIPs", "petadata", "openAPI")
	return
}

// CreateDescribeSecurityIPsResponse creates a response to parse from DescribeSecurityIPs response
func CreateDescribeSecurityIPsResponse() (response *DescribeSecurityIPsResponse) {
	response = &DescribeSecurityIPsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
