package push

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckCertificate invokes the push.CheckCertificate API synchronously
func (client *Client) CheckCertificate(request *CheckCertificateRequest) (response *CheckCertificateResponse, err error) {
	response = CreateCheckCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// CheckCertificateWithChan invokes the push.CheckCertificate API asynchronously
func (client *Client) CheckCertificateWithChan(request *CheckCertificateRequest) (<-chan *CheckCertificateResponse, <-chan error) {
	responseChan := make(chan *CheckCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckCertificateWithCallback invokes the push.CheckCertificate API asynchronously
func (client *Client) CheckCertificateWithCallback(request *CheckCertificateRequest, callback func(response *CheckCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckCertificateResponse
		var err error
		defer close(result)
		response, err = client.CheckCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckCertificateRequest is the request struct for api CheckCertificate
type CheckCertificateRequest struct {
	*requests.RpcRequest
	AppKey requests.Integer `position:"Query" name:"AppKey"`
}

// CheckCertificateResponse is the response struct for api CheckCertificate
type CheckCertificateResponse struct {
	*responses.BaseResponse
	RequestId           string              `json:"RequestId" xml:"RequestId"`
	Android             bool                `json:"Android" xml:"Android"`
	IOS                 bool                `json:"IOS" xml:"IOS"`
	ProductionCertInfo  ProductionCertInfo  `json:"ProductionCertInfo" xml:"ProductionCertInfo"`
	DevelopmentCertInfo DevelopmentCertInfo `json:"DevelopmentCertInfo" xml:"DevelopmentCertInfo"`
}

// CreateCheckCertificateRequest creates a request to invoke CheckCertificate API
func CreateCheckCertificateRequest() (request *CheckCertificateRequest) {
	request = &CheckCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Push", "2016-08-01", "CheckCertificate", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckCertificateResponse creates a response to parse from CheckCertificate response
func CreateCheckCertificateResponse() (response *CheckCertificateResponse) {
	response = &CheckCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
