package pvtz

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteUserVpcAuthorization invokes the pvtz.DeleteUserVpcAuthorization API synchronously
func (client *Client) DeleteUserVpcAuthorization(request *DeleteUserVpcAuthorizationRequest) (response *DeleteUserVpcAuthorizationResponse, err error) {
	response = CreateDeleteUserVpcAuthorizationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteUserVpcAuthorizationWithChan invokes the pvtz.DeleteUserVpcAuthorization API asynchronously
func (client *Client) DeleteUserVpcAuthorizationWithChan(request *DeleteUserVpcAuthorizationRequest) (<-chan *DeleteUserVpcAuthorizationResponse, <-chan error) {
	responseChan := make(chan *DeleteUserVpcAuthorizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteUserVpcAuthorization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteUserVpcAuthorizationWithCallback invokes the pvtz.DeleteUserVpcAuthorization API asynchronously
func (client *Client) DeleteUserVpcAuthorizationWithCallback(request *DeleteUserVpcAuthorizationRequest, callback func(response *DeleteUserVpcAuthorizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteUserVpcAuthorizationResponse
		var err error
		defer close(result)
		response, err = client.DeleteUserVpcAuthorization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteUserVpcAuthorizationRequest is the request struct for api DeleteUserVpcAuthorization
type DeleteUserVpcAuthorizationRequest struct {
	*requests.RpcRequest
	AuthType         string           `position:"Query" name:"AuthType"`
	AuthorizedUserId requests.Integer `position:"Query" name:"AuthorizedUserId"`
}

// DeleteUserVpcAuthorizationResponse is the response struct for api DeleteUserVpcAuthorization
type DeleteUserVpcAuthorizationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteUserVpcAuthorizationRequest creates a request to invoke DeleteUserVpcAuthorization API
func CreateDeleteUserVpcAuthorizationRequest() (request *DeleteUserVpcAuthorizationRequest) {
	request = &DeleteUserVpcAuthorizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("pvtz", "2018-01-01", "DeleteUserVpcAuthorization", "pvtz", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteUserVpcAuthorizationResponse creates a response to parse from DeleteUserVpcAuthorization response
func CreateDeleteUserVpcAuthorizationResponse() (response *DeleteUserVpcAuthorizationResponse) {
	response = &DeleteUserVpcAuthorizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
