package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProductDimensionGroups invokes the quotas.ListProductDimensionGroups API synchronously
func (client *Client) ListProductDimensionGroups(request *ListProductDimensionGroupsRequest) (response *ListProductDimensionGroupsResponse, err error) {
	response = CreateListProductDimensionGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListProductDimensionGroupsWithChan invokes the quotas.ListProductDimensionGroups API asynchronously
func (client *Client) ListProductDimensionGroupsWithChan(request *ListProductDimensionGroupsRequest) (<-chan *ListProductDimensionGroupsResponse, <-chan error) {
	responseChan := make(chan *ListProductDimensionGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProductDimensionGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProductDimensionGroupsWithCallback invokes the quotas.ListProductDimensionGroups API asynchronously
func (client *Client) ListProductDimensionGroupsWithCallback(request *ListProductDimensionGroupsRequest, callback func(response *ListProductDimensionGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProductDimensionGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListProductDimensionGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProductDimensionGroupsRequest is the request struct for api ListProductDimensionGroups
type ListProductDimensionGroupsRequest struct {
	*requests.RpcRequest
	ProductCode string           `position:"Query" name:"ProductCode"`
	NextToken   string           `position:"Query" name:"NextToken"`
	MaxResults  requests.Integer `position:"Query" name:"MaxResults"`
}

// ListProductDimensionGroupsResponse is the response struct for api ListProductDimensionGroups
type ListProductDimensionGroupsResponse struct {
	*responses.BaseResponse
	TotalCount      int                   `json:"TotalCount" xml:"TotalCount"`
	RequestId       string                `json:"RequestId" xml:"RequestId"`
	NextToken       string                `json:"NextToken" xml:"NextToken"`
	MaxResults      int                   `json:"MaxResults" xml:"MaxResults"`
	DimensionGroups []DimensionGroupsItem `json:"DimensionGroups" xml:"DimensionGroups"`
}

// CreateListProductDimensionGroupsRequest creates a request to invoke ListProductDimensionGroups API
func CreateListProductDimensionGroupsRequest() (request *ListProductDimensionGroupsRequest) {
	request = &ListProductDimensionGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ListProductDimensionGroups", "quotas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListProductDimensionGroupsResponse creates a response to parse from ListProductDimensionGroups response
func CreateListProductDimensionGroupsResponse() (response *ListProductDimensionGroupsResponse) {
	response = &ListProductDimensionGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
