package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeInstancesOverview invokes the r_kvstore.DescribeInstancesOverview API synchronously
func (client *Client) DescribeInstancesOverview(request *DescribeInstancesOverviewRequest) (response *DescribeInstancesOverviewResponse, err error) {
	response = CreateDescribeInstancesOverviewResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeInstancesOverviewWithChan invokes the r_kvstore.DescribeInstancesOverview API asynchronously
func (client *Client) DescribeInstancesOverviewWithChan(request *DescribeInstancesOverviewRequest) (<-chan *DescribeInstancesOverviewResponse, <-chan error) {
	responseChan := make(chan *DescribeInstancesOverviewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeInstancesOverview(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeInstancesOverviewWithCallback invokes the r_kvstore.DescribeInstancesOverview API asynchronously
func (client *Client) DescribeInstancesOverviewWithCallback(request *DescribeInstancesOverviewRequest, callback func(response *DescribeInstancesOverviewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeInstancesOverviewResponse
		var err error
		defer close(result)
		response, err = client.DescribeInstancesOverview(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeInstancesOverviewRequest is the request struct for api DescribeInstancesOverview
type DescribeInstancesOverviewRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SearchKey            string           `position:"Query" name:"SearchKey"`
	NetworkType          string           `position:"Query" name:"NetworkType"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	InstanceClass        string           `position:"Query" name:"InstanceClass"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	EditionType          string           `position:"Query" name:"EditionType"`
	InstanceStatus       string           `position:"Query" name:"InstanceStatus"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	GlobalInstance       requests.Boolean `position:"Query" name:"GlobalInstance"`
	PrivateIp            string           `position:"Query" name:"PrivateIp"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	InstanceIds          string           `position:"Query" name:"InstanceIds"`
	ArchitectureType     string           `position:"Query" name:"ArchitectureType"`
	VpcId                string           `position:"Query" name:"VpcId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	ChargeType           string           `position:"Query" name:"ChargeType"`
}

// DescribeInstancesOverviewResponse is the response struct for api DescribeInstancesOverview
type DescribeInstancesOverviewResponse struct {
	*responses.BaseResponse
	RequestId  string            `json:"RequestId" xml:"RequestId"`
	TotalCount int               `json:"TotalCount" xml:"TotalCount"`
	Instances  []KVStoreInstance `json:"Instances" xml:"Instances"`
}

// CreateDescribeInstancesOverviewRequest creates a request to invoke DescribeInstancesOverview API
func CreateDescribeInstancesOverviewRequest() (request *DescribeInstancesOverviewRequest) {
	request = &DescribeInstancesOverviewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "DescribeInstancesOverview", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeInstancesOverviewResponse creates a response to parse from DescribeInstancesOverview response
func CreateDescribeInstancesOverviewResponse() (response *DescribeInstancesOverviewResponse) {
	response = &DescribeInstancesOverviewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
