package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DestroyResourceDirectory invokes the resourcemanager.DestroyResourceDirectory API synchronously
func (client *Client) DestroyResourceDirectory(request *DestroyResourceDirectoryRequest) (response *DestroyResourceDirectoryResponse, err error) {
	response = CreateDestroyResourceDirectoryResponse()
	err = client.DoAction(request, response)
	return
}

// DestroyResourceDirectoryWithChan invokes the resourcemanager.DestroyResourceDirectory API asynchronously
func (client *Client) DestroyResourceDirectoryWithChan(request *DestroyResourceDirectoryRequest) (<-chan *DestroyResourceDirectoryResponse, <-chan error) {
	responseChan := make(chan *DestroyResourceDirectoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DestroyResourceDirectory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DestroyResourceDirectoryWithCallback invokes the resourcemanager.DestroyResourceDirectory API asynchronously
func (client *Client) DestroyResourceDirectoryWithCallback(request *DestroyResourceDirectoryRequest, callback func(response *DestroyResourceDirectoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DestroyResourceDirectoryResponse
		var err error
		defer close(result)
		response, err = client.DestroyResourceDirectory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DestroyResourceDirectoryRequest is the request struct for api DestroyResourceDirectory
type DestroyResourceDirectoryRequest struct {
	*requests.RpcRequest
}

// DestroyResourceDirectoryResponse is the response struct for api DestroyResourceDirectory
type DestroyResourceDirectoryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDestroyResourceDirectoryRequest creates a request to invoke DestroyResourceDirectory API
func CreateDestroyResourceDirectoryRequest() (request *DestroyResourceDirectoryRequest) {
	request = &DestroyResourceDirectoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "DestroyResourceDirectory", "", "")
	request.Method = requests.POST
	return
}

// CreateDestroyResourceDirectoryResponse creates a response to parse from DestroyResourceDirectory response
func CreateDestroyResourceDirectoryResponse() (response *DestroyResourceDirectoryResponse) {
	response = &DestroyResourceDirectoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
