package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeMPULayoutInfoList invokes the rtc.DescribeMPULayoutInfoList API synchronously
func (client *Client) DescribeMPULayoutInfoList(request *DescribeMPULayoutInfoListRequest) (response *DescribeMPULayoutInfoListResponse, err error) {
	response = CreateDescribeMPULayoutInfoListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeMPULayoutInfoListWithChan invokes the rtc.DescribeMPULayoutInfoList API asynchronously
func (client *Client) DescribeMPULayoutInfoListWithChan(request *DescribeMPULayoutInfoListRequest) (<-chan *DescribeMPULayoutInfoListResponse, <-chan error) {
	responseChan := make(chan *DescribeMPULayoutInfoListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeMPULayoutInfoList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeMPULayoutInfoListWithCallback invokes the rtc.DescribeMPULayoutInfoList API asynchronously
func (client *Client) DescribeMPULayoutInfoListWithCallback(request *DescribeMPULayoutInfoListRequest, callback func(response *DescribeMPULayoutInfoListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeMPULayoutInfoListResponse
		var err error
		defer close(result)
		response, err = client.DescribeMPULayoutInfoList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeMPULayoutInfoListRequest is the request struct for api DescribeMPULayoutInfoList
type DescribeMPULayoutInfoListRequest struct {
	*requests.RpcRequest
	PageNum  requests.Integer `position:"Query" name:"PageNum"`
	LayoutId requests.Integer `position:"Query" name:"LayoutId"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
	ShowLog  string           `position:"Query" name:"ShowLog"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
	AppId    string           `position:"Query" name:"AppId"`
	Name     string           `position:"Query" name:"Name"`
}

// DescribeMPULayoutInfoListResponse is the response struct for api DescribeMPULayoutInfoList
type DescribeMPULayoutInfoListResponse struct {
	*responses.BaseResponse
	TotalPage int64   `json:"TotalPage" xml:"TotalPage"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	TotalNum  int64   `json:"TotalNum" xml:"TotalNum"`
	Layouts   Layouts `json:"Layouts" xml:"Layouts"`
}

// CreateDescribeMPULayoutInfoListRequest creates a request to invoke DescribeMPULayoutInfoList API
func CreateDescribeMPULayoutInfoListRequest() (request *DescribeMPULayoutInfoListRequest) {
	request = &DescribeMPULayoutInfoListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeMPULayoutInfoList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeMPULayoutInfoListResponse creates a response to parse from DescribeMPULayoutInfoList response
func CreateDescribeMPULayoutInfoListResponse() (response *DescribeMPULayoutInfoListResponse) {
	response = &DescribeMPULayoutInfoListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
