package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNoticeConfig invokes the sas.DescribeNoticeConfig API synchronously
func (client *Client) DescribeNoticeConfig(request *DescribeNoticeConfigRequest) (response *DescribeNoticeConfigResponse, err error) {
	response = CreateDescribeNoticeConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNoticeConfigWithChan invokes the sas.DescribeNoticeConfig API asynchronously
func (client *Client) DescribeNoticeConfigWithChan(request *DescribeNoticeConfigRequest) (<-chan *DescribeNoticeConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeNoticeConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNoticeConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNoticeConfigWithCallback invokes the sas.DescribeNoticeConfig API asynchronously
func (client *Client) DescribeNoticeConfigWithCallback(request *DescribeNoticeConfigRequest, callback func(response *DescribeNoticeConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNoticeConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeNoticeConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNoticeConfigRequest is the request struct for api DescribeNoticeConfig
type DescribeNoticeConfigRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
}

// DescribeNoticeConfigResponse is the response struct for api DescribeNoticeConfig
type DescribeNoticeConfigResponse struct {
	*responses.BaseResponse
	RequestId        string         `json:"RequestId" xml:"RequestId"`
	NoticeConfigList []NoticeConfig `json:"NoticeConfigList" xml:"NoticeConfigList"`
}

// CreateDescribeNoticeConfigRequest creates a request to invoke DescribeNoticeConfig API
func CreateDescribeNoticeConfigRequest() (request *DescribeNoticeConfigRequest) {
	request = &DescribeNoticeConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeNoticeConfig", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNoticeConfigResponse creates a response to parse from DescribeNoticeConfig response
func CreateDescribeNoticeConfigResponse() (response *DescribeNoticeConfigResponse) {
	response = &DescribeNoticeConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
