package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchStopScdnDomain invokes the scdn.BatchStopScdnDomain API synchronously
func (client *Client) BatchStopScdnDomain(request *BatchStopScdnDomainRequest) (response *BatchStopScdnDomainResponse, err error) {
	response = CreateBatchStopScdnDomainResponse()
	err = client.DoAction(request, response)
	return
}

// BatchStopScdnDomainWithChan invokes the scdn.BatchStopScdnDomain API asynchronously
func (client *Client) BatchStopScdnDomainWithChan(request *BatchStopScdnDomainRequest) (<-chan *BatchStopScdnDomainResponse, <-chan error) {
	responseChan := make(chan *BatchStopScdnDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchStopScdnDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchStopScdnDomainWithCallback invokes the scdn.BatchStopScdnDomain API asynchronously
func (client *Client) BatchStopScdnDomainWithCallback(request *BatchStopScdnDomainRequest, callback func(response *BatchStopScdnDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchStopScdnDomainResponse
		var err error
		defer close(result)
		response, err = client.BatchStopScdnDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchStopScdnDomainRequest is the request struct for api BatchStopScdnDomain
type BatchStopScdnDomainRequest struct {
	*requests.RpcRequest
	DomainNames   string           `position:"Query" name:"DomainNames"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	SecurityToken string           `position:"Query" name:"SecurityToken"`
}

// BatchStopScdnDomainResponse is the response struct for api BatchStopScdnDomain
type BatchStopScdnDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchStopScdnDomainRequest creates a request to invoke BatchStopScdnDomain API
func CreateBatchStopScdnDomainRequest() (request *BatchStopScdnDomainRequest) {
	request = &BatchStopScdnDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "BatchStopScdnDomain", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchStopScdnDomainResponse creates a response to parse from BatchStopScdnDomain response
func CreateBatchStopScdnDomainResponse() (response *BatchStopScdnDomainResponse) {
	response = &BatchStopScdnDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
