package schedulerx2

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteJobs invokes the schedulerx2.BatchDeleteJobs API synchronously
func (client *Client) BatchDeleteJobs(request *BatchDeleteJobsRequest) (response *BatchDeleteJobsResponse, err error) {
	response = CreateBatchDeleteJobsResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteJobsWithChan invokes the schedulerx2.BatchDeleteJobs API asynchronously
func (client *Client) BatchDeleteJobsWithChan(request *BatchDeleteJobsRequest) (<-chan *BatchDeleteJobsResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteJobsWithCallback invokes the schedulerx2.BatchDeleteJobs API asynchronously
func (client *Client) BatchDeleteJobsWithCallback(request *BatchDeleteJobsRequest, callback func(response *BatchDeleteJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteJobsResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteJobsRequest is the request struct for api BatchDeleteJobs
type BatchDeleteJobsRequest struct {
	*requests.RpcRequest
	NamespaceSource string    `position:"Query" name:"NamespaceSource"`
	GroupId         string    `position:"Query" name:"GroupId"`
	JobIdList       *[]string `position:"Body" name:"JobIdList"  type:"Repeated"`
	Namespace       string    `position:"Query" name:"Namespace"`
}

// BatchDeleteJobsResponse is the response struct for api BatchDeleteJobs
type BatchDeleteJobsResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBatchDeleteJobsRequest creates a request to invoke BatchDeleteJobs API
func CreateBatchDeleteJobsRequest() (request *BatchDeleteJobsRequest) {
	request = &BatchDeleteJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("schedulerx2", "2019-04-30", "BatchDeleteJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateBatchDeleteJobsResponse creates a response to parse from BatchDeleteJobs response
func CreateBatchDeleteJobsResponse() (response *BatchDeleteJobsResponse) {
	response = &BatchDeleteJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
