package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEntityTagRelation invokes the scsp.GetEntityTagRelation API synchronously
func (client *Client) GetEntityTagRelation(request *GetEntityTagRelationRequest) (response *GetEntityTagRelationResponse, err error) {
	response = CreateGetEntityTagRelationResponse()
	err = client.DoAction(request, response)
	return
}

// GetEntityTagRelationWithChan invokes the scsp.GetEntityTagRelation API asynchronously
func (client *Client) GetEntityTagRelationWithChan(request *GetEntityTagRelationRequest) (<-chan *GetEntityTagRelationResponse, <-chan error) {
	responseChan := make(chan *GetEntityTagRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEntityTagRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEntityTagRelationWithCallback invokes the scsp.GetEntityTagRelation API asynchronously
func (client *Client) GetEntityTagRelationWithCallback(request *GetEntityTagRelationRequest, callback func(response *GetEntityTagRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEntityTagRelationResponse
		var err error
		defer close(result)
		response, err = client.GetEntityTagRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEntityTagRelationRequest is the request struct for api GetEntityTagRelation
type GetEntityTagRelationRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Body"`
	EntityType string `position:"Body"`
	EntityId   string `position:"Body"`
}

// GetEntityTagRelationResponse is the response struct for api GetEntityTagRelation
type GetEntityTagRelationResponse struct {
	*responses.BaseResponse
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetEntityTagRelationRequest creates a request to invoke GetEntityTagRelation API
func CreateGetEntityTagRelationRequest() (request *GetEntityTagRelationRequest) {
	request = &GetEntityTagRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetEntityTagRelation", "", "")
	request.Method = requests.POST
	return
}

// CreateGetEntityTagRelationResponse creates a response to parse from GetEntityTagRelation response
func CreateGetEntityTagRelationResponse() (response *GetEntityTagRelationResponse) {
	response = &GetEntityTagRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
