package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExpireCaches invokes the sgw.DescribeExpireCaches API synchronously
func (client *Client) DescribeExpireCaches(request *DescribeExpireCachesRequest) (response *DescribeExpireCachesResponse, err error) {
	response = CreateDescribeExpireCachesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExpireCachesWithChan invokes the sgw.DescribeExpireCaches API asynchronously
func (client *Client) DescribeExpireCachesWithChan(request *DescribeExpireCachesRequest) (<-chan *DescribeExpireCachesResponse, <-chan error) {
	responseChan := make(chan *DescribeExpireCachesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExpireCaches(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExpireCachesWithCallback invokes the sgw.DescribeExpireCaches API asynchronously
func (client *Client) DescribeExpireCachesWithCallback(request *DescribeExpireCachesRequest, callback func(response *DescribeExpireCachesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExpireCachesResponse
		var err error
		defer close(result)
		response, err = client.DescribeExpireCaches(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExpireCachesRequest is the request struct for api DescribeExpireCaches
type DescribeExpireCachesRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeExpireCachesResponse is the response struct for api DescribeExpireCaches
type DescribeExpireCachesResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	CacheFilePaths string `json:"CacheFilePaths" xml:"CacheFilePaths"`
}

// CreateDescribeExpireCachesRequest creates a request to invoke DescribeExpireCaches API
func CreateDescribeExpireCachesRequest() (request *DescribeExpireCachesRequest) {
	request = &DescribeExpireCachesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeExpireCaches", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeExpireCachesResponse creates a response to parse from DescribeExpireCaches response
func CreateDescribeExpireCachesResponse() (response *DescribeExpireCachesResponse) {
	response = &DescribeExpireCachesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
