package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayLocations invokes the sgw.DescribeGatewayLocations API synchronously
func (client *Client) DescribeGatewayLocations(request *DescribeGatewayLocationsRequest) (response *DescribeGatewayLocationsResponse, err error) {
	response = CreateDescribeGatewayLocationsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayLocationsWithChan invokes the sgw.DescribeGatewayLocations API asynchronously
func (client *Client) DescribeGatewayLocationsWithChan(request *DescribeGatewayLocationsRequest) (<-chan *DescribeGatewayLocationsResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayLocationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayLocations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayLocationsWithCallback invokes the sgw.DescribeGatewayLocations API asynchronously
func (client *Client) DescribeGatewayLocationsWithCallback(request *DescribeGatewayLocationsRequest, callback func(response *DescribeGatewayLocationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayLocationsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayLocations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayLocationsRequest is the request struct for api DescribeGatewayLocations
type DescribeGatewayLocationsRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// DescribeGatewayLocationsResponse is the response struct for api DescribeGatewayLocations
type DescribeGatewayLocationsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Locations string `json:"Locations" xml:"Locations"`
}

// CreateDescribeGatewayLocationsRequest creates a request to invoke DescribeGatewayLocations API
func CreateDescribeGatewayLocationsRequest() (request *DescribeGatewayLocationsRequest) {
	request = &DescribeGatewayLocationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayLocations", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayLocationsResponse creates a response to parse from DescribeGatewayLocations response
func CreateDescribeGatewayLocationsResponse() (response *DescribeGatewayLocationsResponse) {
	response = &DescribeGatewayLocationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
