package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayModificationClasses invokes the sgw.DescribeGatewayModificationClasses API synchronously
func (client *Client) DescribeGatewayModificationClasses(request *DescribeGatewayModificationClassesRequest) (response *DescribeGatewayModificationClassesResponse, err error) {
	response = CreateDescribeGatewayModificationClassesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayModificationClassesWithChan invokes the sgw.DescribeGatewayModificationClasses API asynchronously
func (client *Client) DescribeGatewayModificationClassesWithChan(request *DescribeGatewayModificationClassesRequest) (<-chan *DescribeGatewayModificationClassesResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayModificationClassesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayModificationClasses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayModificationClassesWithCallback invokes the sgw.DescribeGatewayModificationClasses API asynchronously
func (client *Client) DescribeGatewayModificationClassesWithCallback(request *DescribeGatewayModificationClassesRequest, callback func(response *DescribeGatewayModificationClassesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayModificationClassesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayModificationClasses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayModificationClassesRequest is the request struct for api DescribeGatewayModificationClasses
type DescribeGatewayModificationClassesRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// DescribeGatewayModificationClassesResponse is the response struct for api DescribeGatewayModificationClasses
type DescribeGatewayModificationClassesResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	Success              bool                 `json:"Success" xml:"Success"`
	Code                 string               `json:"Code" xml:"Code"`
	Message              string               `json:"Message" xml:"Message"`
	TargetGatewayClasses TargetGatewayClasses `json:"TargetGatewayClasses" xml:"TargetGatewayClasses"`
}

// CreateDescribeGatewayModificationClassesRequest creates a request to invoke DescribeGatewayModificationClasses API
func CreateDescribeGatewayModificationClassesRequest() (request *DescribeGatewayModificationClassesRequest) {
	request = &DescribeGatewayModificationClassesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayModificationClasses", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayModificationClassesResponse creates a response to parse from DescribeGatewayModificationClasses response
func CreateDescribeGatewayModificationClassesResponse() (response *DescribeGatewayModificationClassesResponse) {
	response = &DescribeGatewayModificationClassesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
