package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateGatewayToken invokes the sgw.GenerateGatewayToken API synchronously
func (client *Client) GenerateGatewayToken(request *GenerateGatewayTokenRequest) (response *GenerateGatewayTokenResponse, err error) {
	response = CreateGenerateGatewayTokenResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateGatewayTokenWithChan invokes the sgw.GenerateGatewayToken API asynchronously
func (client *Client) GenerateGatewayTokenWithChan(request *GenerateGatewayTokenRequest) (<-chan *GenerateGatewayTokenResponse, <-chan error) {
	responseChan := make(chan *GenerateGatewayTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateGatewayToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateGatewayTokenWithCallback invokes the sgw.GenerateGatewayToken API asynchronously
func (client *Client) GenerateGatewayTokenWithCallback(request *GenerateGatewayTokenRequest, callback func(response *GenerateGatewayTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateGatewayTokenResponse
		var err error
		defer close(result)
		response, err = client.GenerateGatewayToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateGatewayTokenRequest is the request struct for api GenerateGatewayToken
type GenerateGatewayTokenRequest struct {
	*requests.RpcRequest
	SecurityToken string `position:"Query" name:"SecurityToken"`
	GatewayId     string `position:"Query" name:"GatewayId"`
}

// GenerateGatewayTokenResponse is the response struct for api GenerateGatewayToken
type GenerateGatewayTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Token     string `json:"Token" xml:"Token"`
}

// CreateGenerateGatewayTokenRequest creates a request to invoke GenerateGatewayToken API
func CreateGenerateGatewayTokenRequest() (request *GenerateGatewayTokenRequest) {
	request = &GenerateGatewayTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "GenerateGatewayToken", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateGatewayTokenResponse creates a response to parse from GenerateGatewayToken response
func CreateGenerateGatewayTokenResponse() (response *GenerateGatewayTokenResponse) {
	response = &GenerateGatewayTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
