package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveSharesFromExpressSync invokes the sgw.RemoveSharesFromExpressSync API synchronously
func (client *Client) RemoveSharesFromExpressSync(request *RemoveSharesFromExpressSyncRequest) (response *RemoveSharesFromExpressSyncResponse, err error) {
	response = CreateRemoveSharesFromExpressSyncResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveSharesFromExpressSyncWithChan invokes the sgw.RemoveSharesFromExpressSync API asynchronously
func (client *Client) RemoveSharesFromExpressSyncWithChan(request *RemoveSharesFromExpressSyncRequest) (<-chan *RemoveSharesFromExpressSyncResponse, <-chan error) {
	responseChan := make(chan *RemoveSharesFromExpressSyncResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveSharesFromExpressSync(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveSharesFromExpressSyncWithCallback invokes the sgw.RemoveSharesFromExpressSync API asynchronously
func (client *Client) RemoveSharesFromExpressSyncWithCallback(request *RemoveSharesFromExpressSyncRequest, callback func(response *RemoveSharesFromExpressSyncResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveSharesFromExpressSyncResponse
		var err error
		defer close(result)
		response, err = client.RemoveSharesFromExpressSync(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveSharesFromExpressSyncRequest is the request struct for api RemoveSharesFromExpressSync
type RemoveSharesFromExpressSyncRequest struct {
	*requests.RpcRequest
	ExpressSyncId string `position:"Query" name:"ExpressSyncId"`
	GatewayShares string `position:"Query" name:"GatewayShares"`
	SecurityToken string `position:"Query" name:"SecurityToken"`
}

// RemoveSharesFromExpressSyncResponse is the response struct for api RemoveSharesFromExpressSync
type RemoveSharesFromExpressSyncResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateRemoveSharesFromExpressSyncRequest creates a request to invoke RemoveSharesFromExpressSync API
func CreateRemoveSharesFromExpressSyncRequest() (request *RemoveSharesFromExpressSyncRequest) {
	request = &RemoveSharesFromExpressSyncRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "RemoveSharesFromExpressSync", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRemoveSharesFromExpressSyncResponse creates a response to parse from RemoveSharesFromExpressSync response
func CreateRemoveSharesFromExpressSyncResponse() (response *RemoveSharesFromExpressSyncResponse) {
	response = &RemoveSharesFromExpressSyncResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
