package slb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTLSCipherPolicy invokes the slb.DeleteTLSCipherPolicy API synchronously
func (client *Client) DeleteTLSCipherPolicy(request *DeleteTLSCipherPolicyRequest) (response *DeleteTLSCipherPolicyResponse, err error) {
	response = CreateDeleteTLSCipherPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTLSCipherPolicyWithChan invokes the slb.DeleteTLSCipherPolicy API asynchronously
func (client *Client) DeleteTLSCipherPolicyWithChan(request *DeleteTLSCipherPolicyRequest) (<-chan *DeleteTLSCipherPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteTLSCipherPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTLSCipherPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTLSCipherPolicyWithCallback invokes the slb.DeleteTLSCipherPolicy API asynchronously
func (client *Client) DeleteTLSCipherPolicyWithCallback(request *DeleteTLSCipherPolicyRequest, callback func(response *DeleteTLSCipherPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTLSCipherPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteTLSCipherPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTLSCipherPolicyRequest is the request struct for api DeleteTLSCipherPolicy
type DeleteTLSCipherPolicyRequest struct {
	*requests.RpcRequest
	AccessKeyId          string           `position:"Query" name:"access_key_id"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TLSCipherPolicyId    string           `position:"Query" name:"TLSCipherPolicyId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteTLSCipherPolicyResponse is the response struct for api DeleteTLSCipherPolicy
type DeleteTLSCipherPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTLSCipherPolicyRequest creates a request to invoke DeleteTLSCipherPolicy API
func CreateDeleteTLSCipherPolicyRequest() (request *DeleteTLSCipherPolicyRequest) {
	request = &DeleteTLSCipherPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Slb", "2014-05-15", "DeleteTLSCipherPolicy", "Slb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTLSCipherPolicyResponse creates a response to parse from DeleteTLSCipherPolicy response
func CreateDeleteTLSCipherPolicyResponse() (response *DeleteTLSCipherPolicyResponse) {
	response = &DeleteTLSCipherPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
