package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagUserDns invokes the smartag.DescribeSagUserDns API synchronously
func (client *Client) DescribeSagUserDns(request *DescribeSagUserDnsRequest) (response *DescribeSagUserDnsResponse, err error) {
	response = CreateDescribeSagUserDnsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagUserDnsWithChan invokes the smartag.DescribeSagUserDns API asynchronously
func (client *Client) DescribeSagUserDnsWithChan(request *DescribeSagUserDnsRequest) (<-chan *DescribeSagUserDnsResponse, <-chan error) {
	responseChan := make(chan *DescribeSagUserDnsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagUserDns(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagUserDnsWithCallback invokes the smartag.DescribeSagUserDns API asynchronously
func (client *Client) DescribeSagUserDnsWithCallback(request *DescribeSagUserDnsRequest, callback func(response *DescribeSagUserDnsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagUserDnsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagUserDns(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagUserDnsRequest is the request struct for api DescribeSagUserDns
type DescribeSagUserDnsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// DescribeSagUserDnsResponse is the response struct for api DescribeSagUserDns
type DescribeSagUserDnsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	SlaveDns   string      `json:"SlaveDns" xml:"SlaveDns"`
	MasterDns  string      `json:"MasterDns" xml:"MasterDns"`
	TaskStates []TaskState `json:"TaskStates" xml:"TaskStates"`
}

// CreateDescribeSagUserDnsRequest creates a request to invoke DescribeSagUserDns API
func CreateDescribeSagUserDnsRequest() (request *DescribeSagUserDnsRequest) {
	request = &DescribeSagUserDnsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagUserDns", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSagUserDnsResponse creates a response to parse from DescribeSagUserDns response
func CreateDescribeSagUserDnsResponse() (response *DescribeSagUserDnsResponse) {
	response = &DescribeSagUserDnsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
