package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSmartAGByAccessPoint invokes the smartag.ListSmartAGByAccessPoint API synchronously
func (client *Client) ListSmartAGByAccessPoint(request *ListSmartAGByAccessPointRequest) (response *ListSmartAGByAccessPointResponse, err error) {
	response = CreateListSmartAGByAccessPointResponse()
	err = client.DoAction(request, response)
	return
}

// ListSmartAGByAccessPointWithChan invokes the smartag.ListSmartAGByAccessPoint API asynchronously
func (client *Client) ListSmartAGByAccessPointWithChan(request *ListSmartAGByAccessPointRequest) (<-chan *ListSmartAGByAccessPointResponse, <-chan error) {
	responseChan := make(chan *ListSmartAGByAccessPointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSmartAGByAccessPoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSmartAGByAccessPointWithCallback invokes the smartag.ListSmartAGByAccessPoint API asynchronously
func (client *Client) ListSmartAGByAccessPointWithCallback(request *ListSmartAGByAccessPointRequest, callback func(response *ListSmartAGByAccessPointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSmartAGByAccessPointResponse
		var err error
		defer close(result)
		response, err = client.ListSmartAGByAccessPoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSmartAGByAccessPointRequest is the request struct for api ListSmartAGByAccessPoint
type ListSmartAGByAccessPointRequest struct {
	*requests.RpcRequest
	AccessPointId        requests.Integer `position:"Query" name:"AccessPointId"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGStatus        string           `position:"Query" name:"SmartAGStatus"`
}

// ListSmartAGByAccessPointResponse is the response struct for api ListSmartAGByAccessPoint
type ListSmartAGByAccessPointResponse struct {
	*responses.BaseResponse
	TotalCount          int                  `json:"TotalCount" xml:"TotalCount"`
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	SmartAccessGateways []SmartAccessGateway `json:"SmartAccessGateways" xml:"SmartAccessGateways"`
}

// CreateListSmartAGByAccessPointRequest creates a request to invoke ListSmartAGByAccessPoint API
func CreateListSmartAGByAccessPointRequest() (request *ListSmartAGByAccessPointRequest) {
	request = &ListSmartAGByAccessPointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ListSmartAGByAccessPoint", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSmartAGByAccessPointResponse creates a response to parse from ListSmartAGByAccessPoint response
func CreateListSmartAGByAccessPointResponse() (response *ListSmartAGByAccessPointResponse) {
	response = &ListSmartAGByAccessPointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
