package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySmartAccessGatewayClientUser invokes the smartag.ModifySmartAccessGatewayClientUser API synchronously
func (client *Client) ModifySmartAccessGatewayClientUser(request *ModifySmartAccessGatewayClientUserRequest) (response *ModifySmartAccessGatewayClientUserResponse, err error) {
	response = CreateModifySmartAccessGatewayClientUserResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySmartAccessGatewayClientUserWithChan invokes the smartag.ModifySmartAccessGatewayClientUser API asynchronously
func (client *Client) ModifySmartAccessGatewayClientUserWithChan(request *ModifySmartAccessGatewayClientUserRequest) (<-chan *ModifySmartAccessGatewayClientUserResponse, <-chan error) {
	responseChan := make(chan *ModifySmartAccessGatewayClientUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySmartAccessGatewayClientUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySmartAccessGatewayClientUserWithCallback invokes the smartag.ModifySmartAccessGatewayClientUser API asynchronously
func (client *Client) ModifySmartAccessGatewayClientUserWithCallback(request *ModifySmartAccessGatewayClientUserRequest, callback func(response *ModifySmartAccessGatewayClientUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySmartAccessGatewayClientUserResponse
		var err error
		defer close(result)
		response, err = client.ModifySmartAccessGatewayClientUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySmartAccessGatewayClientUserRequest is the request struct for api ModifySmartAccessGatewayClientUser
type ModifySmartAccessGatewayClientUserRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientIp             string           `position:"Query" name:"ClientIp"`
	Email                string           `position:"Query" name:"Email"`
	EnableStaticIp       requests.Boolean `position:"Query" name:"EnableStaticIp"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth            requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	UserName             string           `position:"Query" name:"UserName"`
}

// ModifySmartAccessGatewayClientUserResponse is the response struct for api ModifySmartAccessGatewayClientUser
type ModifySmartAccessGatewayClientUserResponse struct {
	*responses.BaseResponse
	UserName  string `json:"UserName" xml:"UserName"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	UserMail  string `json:"UserMail" xml:"UserMail"`
	Bandwidth int    `json:"Bandwidth" xml:"Bandwidth"`
	ClientIp  string `json:"ClientIp" xml:"ClientIp"`
}

// CreateModifySmartAccessGatewayClientUserRequest creates a request to invoke ModifySmartAccessGatewayClientUser API
func CreateModifySmartAccessGatewayClientUserRequest() (request *ModifySmartAccessGatewayClientUserRequest) {
	request = &ModifySmartAccessGatewayClientUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySmartAccessGatewayClientUser", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifySmartAccessGatewayClientUserResponse creates a response to parse from ModifySmartAccessGatewayClientUser response
func CreateModifySmartAccessGatewayClientUserResponse() (response *ModifySmartAccessGatewayClientUserResponse) {
	response = &ModifySmartAccessGatewayClientUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
