package snsuapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BandStatusQuery invokes the snsuapi.BandStatusQuery API synchronously
// api document: https://help.aliyun.com/api/snsuapi/bandstatusquery.html
func (client *Client) BandStatusQuery(request *BandStatusQueryRequest) (response *BandStatusQueryResponse, err error) {
	response = CreateBandStatusQueryResponse()
	err = client.DoAction(request, response)
	return
}

// BandStatusQueryWithChan invokes the snsuapi.BandStatusQuery API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/bandstatusquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BandStatusQueryWithChan(request *BandStatusQueryRequest) (<-chan *BandStatusQueryResponse, <-chan error) {
	responseChan := make(chan *BandStatusQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BandStatusQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BandStatusQueryWithCallback invokes the snsuapi.BandStatusQuery API asynchronously
// api document: https://help.aliyun.com/api/snsuapi/bandstatusquery.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BandStatusQueryWithCallback(request *BandStatusQueryRequest, callback func(response *BandStatusQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BandStatusQueryResponse
		var err error
		defer close(result)
		response, err = client.BandStatusQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BandStatusQueryRequest is the request struct for api BandStatusQuery
type BandStatusQueryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	BandId               requests.Integer `position:"Query" name:"BandId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// BandStatusQueryResponse is the response struct for api BandStatusQuery
type BandStatusQueryResponse struct {
	*responses.BaseResponse
	RequestId     string       `json:"RequestId" xml:"RequestId"`
	ResultCode    string       `json:"ResultCode" xml:"ResultCode"`
	ResultMessage string       `json:"ResultMessage" xml:"ResultMessage"`
	ResultModule  ResultModule `json:"ResultModule" xml:"ResultModule"`
}

// CreateBandStatusQueryRequest creates a request to invoke BandStatusQuery API
func CreateBandStatusQueryRequest() (request *BandStatusQueryRequest) {
	request = &BandStatusQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Snsuapi", "2018-07-09", "BandStatusQuery", "snsuapi", "openAPI")
	return
}

// CreateBandStatusQueryResponse creates a response to parse from BandStatusQuery response
func CreateBandStatusQueryResponse() (response *BandStatusQueryResponse) {
	response = &BandStatusQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
