package subscription

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWebhook invokes the subscription.UpdateWebhook API synchronously
// api document: https://help.aliyun.com/api/subscription/updatewebhook.html
func (client *Client) UpdateWebhook(request *UpdateWebhookRequest) (response *UpdateWebhookResponse, err error) {
	response = CreateUpdateWebhookResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWebhookWithChan invokes the subscription.UpdateWebhook API asynchronously
// api document: https://help.aliyun.com/api/subscription/updatewebhook.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWebhookWithChan(request *UpdateWebhookRequest) (<-chan *UpdateWebhookResponse, <-chan error) {
	responseChan := make(chan *UpdateWebhookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWebhook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWebhookWithCallback invokes the subscription.UpdateWebhook API asynchronously
// api document: https://help.aliyun.com/api/subscription/updatewebhook.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateWebhookWithCallback(request *UpdateWebhookRequest, callback func(response *UpdateWebhookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWebhookResponse
		var err error
		defer close(result)
		response, err = client.UpdateWebhook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWebhookRequest is the request struct for api UpdateWebhook
type UpdateWebhookRequest struct {
	*requests.RpcRequest
	WebhookId   requests.Integer `position:"Body" name:"WebhookId"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	Locale      string           `position:"Query" name:"Locale"`
	ServerUrl   string           `position:"Body" name:"ServerUrl"`
	Name        string           `position:"Body" name:"Name"`
}

// UpdateWebhookResponse is the response struct for api UpdateWebhook
type UpdateWebhookResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateUpdateWebhookRequest creates a request to invoke UpdateWebhook API
func CreateUpdateWebhookRequest() (request *UpdateWebhookRequest) {
	request = &UpdateWebhookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Subscription", "2021-01-15", "UpdateWebhook", "", "")
	return
}

// CreateUpdateWebhookResponse creates a response to parse from UpdateWebhook response
func CreateUpdateWebhookResponse() (response *UpdateWebhookResponse) {
	response = &UpdateWebhookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
