package teambition_aliyun

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckAliyunUserExists invokes the teambition_aliyun.CheckAliyunUserExists API synchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/checkaliyunuserexists.html
func (client *Client) CheckAliyunUserExists(request *CheckAliyunUserExistsRequest) (response *CheckAliyunUserExistsResponse, err error) {
	response = CreateCheckAliyunUserExistsResponse()
	err = client.DoAction(request, response)
	return
}

// CheckAliyunUserExistsWithChan invokes the teambition_aliyun.CheckAliyunUserExists API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/checkaliyunuserexists.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckAliyunUserExistsWithChan(request *CheckAliyunUserExistsRequest) (<-chan *CheckAliyunUserExistsResponse, <-chan error) {
	responseChan := make(chan *CheckAliyunUserExistsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckAliyunUserExists(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckAliyunUserExistsWithCallback invokes the teambition_aliyun.CheckAliyunUserExists API asynchronously
// api document: https://help.aliyun.com/api/teambition-aliyun/checkaliyunuserexists.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CheckAliyunUserExistsWithCallback(request *CheckAliyunUserExistsRequest, callback func(response *CheckAliyunUserExistsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckAliyunUserExistsResponse
		var err error
		defer close(result)
		response, err = client.CheckAliyunUserExists(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckAliyunUserExistsRequest is the request struct for api CheckAliyunUserExists
type CheckAliyunUserExistsRequest struct {
	*requests.RpcRequest
	UserPk string `position:"Body" name:"UserPk"`
}

// CheckAliyunUserExistsResponse is the response struct for api CheckAliyunUserExists
type CheckAliyunUserExistsResponse struct {
	*responses.BaseResponse
	Successful bool   `json:"Successful" xml:"Successful"`
	ErrorCode  string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg   string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Object     bool   `json:"Object" xml:"Object"`
}

// CreateCheckAliyunUserExistsRequest creates a request to invoke CheckAliyunUserExists API
func CreateCheckAliyunUserExistsRequest() (request *CheckAliyunUserExistsRequest) {
	request = &CheckAliyunUserExistsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("teambition-aliyun", "2020-02-26", "CheckAliyunUserExists", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckAliyunUserExistsResponse creates a response to parse from CheckAliyunUserExists response
func CreateCheckAliyunUserExistsResponse() (response *CheckAliyunUserExistsResponse) {
	response = &CheckAliyunUserExistsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
