package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListNotaryInfos invokes the trademark.ListNotaryInfos API synchronously
// api document: https://help.aliyun.com/api/trademark/listnotaryinfos.html
func (client *Client) ListNotaryInfos(request *ListNotaryInfosRequest) (response *ListNotaryInfosResponse, err error) {
	response = CreateListNotaryInfosResponse()
	err = client.DoAction(request, response)
	return
}

// ListNotaryInfosWithChan invokes the trademark.ListNotaryInfos API asynchronously
// api document: https://help.aliyun.com/api/trademark/listnotaryinfos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNotaryInfosWithChan(request *ListNotaryInfosRequest) (<-chan *ListNotaryInfosResponse, <-chan error) {
	responseChan := make(chan *ListNotaryInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListNotaryInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListNotaryInfosWithCallback invokes the trademark.ListNotaryInfos API asynchronously
// api document: https://help.aliyun.com/api/trademark/listnotaryinfos.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListNotaryInfosWithCallback(request *ListNotaryInfosRequest, callback func(response *ListNotaryInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListNotaryInfosResponse
		var err error
		defer close(result)
		response, err = client.ListNotaryInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListNotaryInfosRequest is the request struct for api ListNotaryInfos
type ListNotaryInfosRequest struct {
	*requests.RpcRequest
	BizOrderNo string           `position:"Query" name:"BizOrderNo"`
	NotaryType requests.Integer `position:"Query" name:"NotaryType"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNum    requests.Integer `position:"Query" name:"PageNum"`
	Token      string           `position:"Query" name:"Token"`
}

// ListNotaryInfosResponse is the response struct for api ListNotaryInfos
type ListNotaryInfosResponse struct {
	*responses.BaseResponse
	RequestId      string                `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int                   `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int                   `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int                   `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                   `json:"TotalPageNum" xml:"TotalPageNum"`
	PrePage        bool                  `json:"PrePage" xml:"PrePage"`
	NextPage       bool                  `json:"NextPage" xml:"NextPage"`
	Success        bool                  `json:"Success" xml:"Success"`
	ErrorMsg       string                `json:"ErrorMsg" xml:"ErrorMsg"`
	ErrorCode      string                `json:"ErrorCode" xml:"ErrorCode"`
	Data           DataInListNotaryInfos `json:"Data" xml:"Data"`
}

// CreateListNotaryInfosRequest creates a request to invoke ListNotaryInfos API
func CreateListNotaryInfosRequest() (request *ListNotaryInfosRequest) {
	request = &ListNotaryInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "ListNotaryInfos", "trademark", "openAPI")
	return
}

// CreateListNotaryInfosResponse creates a response to parse from ListNotaryInfos response
func CreateListNotaryInfosResponse() (response *ListNotaryInfosResponse) {
	response = &ListNotaryInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
