package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateOrderProxy invokes the unimkt.CreateOrderProxy API synchronously
func (client *Client) CreateOrderProxy(request *CreateOrderProxyRequest) (response *CreateOrderProxyResponse, err error) {
	response = CreateCreateOrderProxyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateOrderProxyWithChan invokes the unimkt.CreateOrderProxy API asynchronously
func (client *Client) CreateOrderProxyWithChan(request *CreateOrderProxyRequest) (<-chan *CreateOrderProxyResponse, <-chan error) {
	responseChan := make(chan *CreateOrderProxyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateOrderProxy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateOrderProxyWithCallback invokes the unimkt.CreateOrderProxy API asynchronously
func (client *Client) CreateOrderProxyWithCallback(request *CreateOrderProxyRequest, callback func(response *CreateOrderProxyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateOrderProxyResponse
		var err error
		defer close(result)
		response, err = client.CreateOrderProxy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateOrderProxyRequest is the request struct for api CreateOrderProxy
type CreateOrderProxyRequest struct {
	*requests.RpcRequest
	SalePrice   requests.Float `position:"Query" name:"SalePrice"`
	CommodityId string         `position:"Query" name:"CommodityId"`
	HolderId    string         `position:"Query" name:"HolderId"`
	PromotionId string         `position:"Query" name:"PromotionId"`
	DeviceType  string         `position:"Query" name:"DeviceType"`
	AlipayUid   string         `position:"Query" name:"AlipayUid"`
	DeviceCode  string         `position:"Query" name:"DeviceCode"`
	V           string         `position:"Query" name:"V"`
	ChannelId   string         `position:"Query" name:"ChannelId"`
	OuterCode   string         `position:"Query" name:"OuterCode"`
	QueryStr    string         `position:"Query" name:"QueryStr"`
}

// CreateOrderProxyResponse is the response struct for api CreateOrderProxy
type CreateOrderProxyResponse struct {
	*responses.BaseResponse
	Status        bool   `json:"Status" xml:"Status"`
	Msg           string `json:"Msg" xml:"Msg"`
	AliPayOrderId string `json:"AliPayOrderId" xml:"AliPayOrderId"`
	ErrorCode     string `json:"ErrorCode" xml:"ErrorCode"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateOrderProxyRequest creates a request to invoke CreateOrderProxy API
func CreateCreateOrderProxyRequest() (request *CreateOrderProxyRequest) {
	request = &CreateOrderProxyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-07", "CreateOrderProxy", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateOrderProxyResponse creates a response to parse from CreateOrderProxy response
func CreateCreateOrderProxyResponse() (response *CreateOrderProxyResponse) {
	response = &CreateOrderProxyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
