package unimkt

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUnionTaskInfo invokes the unimkt.QueryUnionTaskInfo API synchronously
func (client *Client) QueryUnionTaskInfo(request *QueryUnionTaskInfoRequest) (response *QueryUnionTaskInfoResponse, err error) {
	response = CreateQueryUnionTaskInfoResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUnionTaskInfoWithChan invokes the unimkt.QueryUnionTaskInfo API asynchronously
func (client *Client) QueryUnionTaskInfoWithChan(request *QueryUnionTaskInfoRequest) (<-chan *QueryUnionTaskInfoResponse, <-chan error) {
	responseChan := make(chan *QueryUnionTaskInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUnionTaskInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUnionTaskInfoWithCallback invokes the unimkt.QueryUnionTaskInfo API asynchronously
func (client *Client) QueryUnionTaskInfoWithCallback(request *QueryUnionTaskInfoRequest, callback func(response *QueryUnionTaskInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUnionTaskInfoResponse
		var err error
		defer close(result)
		response, err = client.QueryUnionTaskInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUnionTaskInfoRequest is the request struct for api QueryUnionTaskInfo
type QueryUnionTaskInfoRequest struct {
	*requests.RpcRequest
	ProxyUserId requests.Integer `position:"Query" name:"ProxyUserId"`
	ChannelId   string           `position:"Query" name:"ChannelId"`
	TaskId      requests.Integer `position:"Query" name:"TaskId"`
}

// QueryUnionTaskInfoResponse is the response struct for api QueryUnionTaskInfo
type QueryUnionTaskInfoResponse struct {
	*responses.BaseResponse
	Code      int                      `json:"Code" xml:"Code"`
	Success   bool                     `json:"Success" xml:"Success"`
	ErrorMsg  string                   `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string                   `json:"RequestId" xml:"RequestId"`
	Data      []map[string]interface{} `json:"Data" xml:"Data"`
}

// CreateQueryUnionTaskInfoRequest creates a request to invoke QueryUnionTaskInfo API
func CreateQueryUnionTaskInfoRequest() (request *QueryUnionTaskInfoRequest) {
	request = &QueryUnionTaskInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("UniMkt", "2018-12-12", "QueryUnionTaskInfo", "uniMkt", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUnionTaskInfoResponse creates a response to parse from QueryUnionTaskInfo response
func CreateQueryUnionTaskInfoResponse() (response *QueryUnionTaskInfoResponse) {
	response = &QueryUnionTaskInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
