package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InvokeMotorModel invokes the vcs.InvokeMotorModel API synchronously
func (client *Client) InvokeMotorModel(request *InvokeMotorModelRequest) (response *InvokeMotorModelResponse, err error) {
	response = CreateInvokeMotorModelResponse()
	err = client.DoAction(request, response)
	return
}

// InvokeMotorModelWithChan invokes the vcs.InvokeMotorModel API asynchronously
func (client *Client) InvokeMotorModelWithChan(request *InvokeMotorModelRequest) (<-chan *InvokeMotorModelResponse, <-chan error) {
	responseChan := make(chan *InvokeMotorModelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InvokeMotorModel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InvokeMotorModelWithCallback invokes the vcs.InvokeMotorModel API asynchronously
func (client *Client) InvokeMotorModelWithCallback(request *InvokeMotorModelRequest, callback func(response *InvokeMotorModelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InvokeMotorModelResponse
		var err error
		defer close(result)
		response, err = client.InvokeMotorModel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InvokeMotorModelRequest is the request struct for api InvokeMotorModel
type InvokeMotorModelRequest struct {
	*requests.RpcRequest
	PicPath string `position:"Body" name:"PicPath"`
	CorpId  string `position:"Body" name:"CorpId"`
	PicUrl  string `position:"Body" name:"PicUrl"`
	PicId   string `position:"Body" name:"PicId"`
}

// InvokeMotorModelResponse is the response struct for api InvokeMotorModel
type InvokeMotorModelResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateInvokeMotorModelRequest creates a request to invoke InvokeMotorModel API
func CreateInvokeMotorModelRequest() (request *InvokeMotorModelRequest) {
	request = &InvokeMotorModelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "InvokeMotorModel", "", "")
	request.Method = requests.POST
	return
}

// CreateInvokeMotorModelResponse creates a response to parse from InvokeMotorModel response
func CreateInvokeMotorModelResponse() (response *InvokeMotorModelResponse) {
	response = &InvokeMotorModelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
