package visionai_poc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecognizeCar invokes the visionai_poc.RecognizeCar API synchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizecar.html
func (client *Client) RecognizeCar(request *RecognizeCarRequest) (response *RecognizeCarResponse, err error) {
	response = CreateRecognizeCarResponse()
	err = client.DoAction(request, response)
	return
}

// RecognizeCarWithChan invokes the visionai_poc.RecognizeCar API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizecar.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeCarWithChan(request *RecognizeCarRequest) (<-chan *RecognizeCarResponse, <-chan error) {
	responseChan := make(chan *RecognizeCarResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecognizeCar(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecognizeCarWithCallback invokes the visionai_poc.RecognizeCar API asynchronously
// api document: https://help.aliyun.com/api/visionai-poc/recognizecar.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RecognizeCarWithCallback(request *RecognizeCarRequest, callback func(response *RecognizeCarResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecognizeCarResponse
		var err error
		defer close(result)
		response, err = client.RecognizeCar(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecognizeCarRequest is the request struct for api RecognizeCar
type RecognizeCarRequest struct {
	*requests.RpcRequest
	Method   string `position:"Body" name:"Method"`
	ImageUrl string `position:"Body" name:"ImageUrl"`
	Url      string `position:"Body" name:"Url"`
}

// RecognizeCarResponse is the response struct for api RecognizeCar
type RecognizeCarResponse struct {
	*responses.BaseResponse
	Code     int                    `json:"Code" xml:"Code"`
	Message  string                 `json:"Message" xml:"Message"`
	Success  bool                   `json:"Success" xml:"Success"`
	Response ResponseInRecognizeCar `json:"Response" xml:"Response"`
}

// CreateRecognizeCarRequest creates a request to invoke RecognizeCar API
func CreateRecognizeCarRequest() (request *RecognizeCarRequest) {
	request = &RecognizeCarRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("visionai-poc", "2020-04-08", "RecognizeCar", "", "")
	return
}

// CreateRecognizeCarResponse creates a response to parse from RecognizeCar response
func CreateRecognizeCarResponse() (response *RecognizeCarResponse) {
	response = &RecognizeCarResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
