package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAITemplate invokes the vod.DeleteAITemplate API synchronously
func (client *Client) DeleteAITemplate(request *DeleteAITemplateRequest) (response *DeleteAITemplateResponse, err error) {
	response = CreateDeleteAITemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAITemplateWithChan invokes the vod.DeleteAITemplate API asynchronously
func (client *Client) DeleteAITemplateWithChan(request *DeleteAITemplateRequest) (<-chan *DeleteAITemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteAITemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAITemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAITemplateWithCallback invokes the vod.DeleteAITemplate API asynchronously
func (client *Client) DeleteAITemplateWithCallback(request *DeleteAITemplateRequest, callback func(response *DeleteAITemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAITemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteAITemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAITemplateRequest is the request struct for api DeleteAITemplate
type DeleteAITemplateRequest struct {
	*requests.RpcRequest
	TemplateId string `position:"Query" name:"TemplateId"`
}

// DeleteAITemplateResponse is the response struct for api DeleteAITemplate
type DeleteAITemplateResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId string `json:"TemplateId" xml:"TemplateId"`
}

// CreateDeleteAITemplateRequest creates a request to invoke DeleteAITemplate API
func CreateDeleteAITemplateRequest() (request *DeleteAITemplateRequest) {
	request = &DeleteAITemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DeleteAITemplate", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAITemplateResponse creates a response to parse from DeleteAITemplate response
func CreateDeleteAITemplateResponse() (response *DeleteAITemplateResponse) {
	response = &DeleteAITemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
