package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UploadStreamByURL invokes the vod.UploadStreamByURL API synchronously
func (client *Client) UploadStreamByURL(request *UploadStreamByURLRequest) (response *UploadStreamByURLResponse, err error) {
	response = CreateUploadStreamByURLResponse()
	err = client.DoAction(request, response)
	return
}

// UploadStreamByURLWithChan invokes the vod.UploadStreamByURL API asynchronously
func (client *Client) UploadStreamByURLWithChan(request *UploadStreamByURLRequest) (<-chan *UploadStreamByURLResponse, <-chan error) {
	responseChan := make(chan *UploadStreamByURLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UploadStreamByURL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UploadStreamByURLWithCallback invokes the vod.UploadStreamByURL API asynchronously
func (client *Client) UploadStreamByURLWithCallback(request *UploadStreamByURLRequest, callback func(response *UploadStreamByURLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UploadStreamByURLResponse
		var err error
		defer close(result)
		response, err = client.UploadStreamByURL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UploadStreamByURLRequest is the request struct for api UploadStreamByURL
type UploadStreamByURLRequest struct {
	*requests.RpcRequest
	FileExtension string `position:"Query" name:"FileExtension"`
	UserData      string `position:"Query" name:"UserData"`
	HDRType       string `position:"Query" name:"HDRType"`
	Definition    string `position:"Query" name:"Definition"`
	StreamURL     string `position:"Query" name:"StreamURL"`
	MediaId       string `position:"Query" name:"MediaId"`
}

// UploadStreamByURLResponse is the response struct for api UploadStreamByURL
type UploadStreamByURLResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	StreamJobId string `json:"StreamJobId" xml:"StreamJobId"`
	FileURL     string `json:"FileURL" xml:"FileURL"`
	SourceURL   string `json:"SourceURL" xml:"SourceURL"`
}

// CreateUploadStreamByURLRequest creates a request to invoke UploadStreamByURL API
func CreateUploadStreamByURLRequest() (request *UploadStreamByURLRequest) {
	request = &UploadStreamByURLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "UploadStreamByURL", "vod", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUploadStreamByURLResponse creates a response to parse from UploadStreamByURL response
func CreateUploadStreamByURLResponse() (response *UploadStreamByURLResponse) {
	response = &UploadStreamByURLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
