package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DebugBeginDialogue invokes the voicenavigator.DebugBeginDialogue API synchronously
func (client *Client) DebugBeginDialogue(request *DebugBeginDialogueRequest) (response *DebugBeginDialogueResponse, err error) {
	response = CreateDebugBeginDialogueResponse()
	err = client.DoAction(request, response)
	return
}

// DebugBeginDialogueWithChan invokes the voicenavigator.DebugBeginDialogue API asynchronously
func (client *Client) DebugBeginDialogueWithChan(request *DebugBeginDialogueRequest) (<-chan *DebugBeginDialogueResponse, <-chan error) {
	responseChan := make(chan *DebugBeginDialogueResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DebugBeginDialogue(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DebugBeginDialogueWithCallback invokes the voicenavigator.DebugBeginDialogue API asynchronously
func (client *Client) DebugBeginDialogueWithCallback(request *DebugBeginDialogueRequest, callback func(response *DebugBeginDialogueResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DebugBeginDialogueResponse
		var err error
		defer close(result)
		response, err = client.DebugBeginDialogue(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DebugBeginDialogueRequest is the request struct for api DebugBeginDialogue
type DebugBeginDialogueRequest struct {
	*requests.RpcRequest
	ConversationId string `position:"Query" name:"ConversationId"`
	InitialContext string `position:"Query" name:"InitialContext"`
	CallingNumber  string `position:"Query" name:"CallingNumber"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	CalledNumber   string `position:"Query" name:"CalledNumber"`
}

// DebugBeginDialogueResponse is the response struct for api DebugBeginDialogue
type DebugBeginDialogueResponse struct {
	*responses.BaseResponse
	Action        string `json:"Action" xml:"Action"`
	ActionParams  string `json:"ActionParams" xml:"ActionParams"`
	Interruptible bool   `json:"Interruptible" xml:"Interruptible"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	TextResponse  string `json:"TextResponse" xml:"TextResponse"`
}

// CreateDebugBeginDialogueRequest creates a request to invoke DebugBeginDialogue API
func CreateDebugBeginDialogueRequest() (request *DebugBeginDialogueRequest) {
	request = &DebugBeginDialogueRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "DebugBeginDialogue", "voicebot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDebugBeginDialogueResponse creates a response to parse from DebugBeginDialogue response
func CreateDebugBeginDialogueResponse() (response *DebugBeginDialogueResponse) {
	response = &DebugBeginDialogueResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
