package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociateRouteTablesWithVpcGatewayEndpoint invokes the vpc.AssociateRouteTablesWithVpcGatewayEndpoint API synchronously
func (client *Client) AssociateRouteTablesWithVpcGatewayEndpoint(request *AssociateRouteTablesWithVpcGatewayEndpointRequest) (response *AssociateRouteTablesWithVpcGatewayEndpointResponse, err error) {
	response = CreateAssociateRouteTablesWithVpcGatewayEndpointResponse()
	err = client.DoAction(request, response)
	return
}

// AssociateRouteTablesWithVpcGatewayEndpointWithChan invokes the vpc.AssociateRouteTablesWithVpcGatewayEndpoint API asynchronously
func (client *Client) AssociateRouteTablesWithVpcGatewayEndpointWithChan(request *AssociateRouteTablesWithVpcGatewayEndpointRequest) (<-chan *AssociateRouteTablesWithVpcGatewayEndpointResponse, <-chan error) {
	responseChan := make(chan *AssociateRouteTablesWithVpcGatewayEndpointResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociateRouteTablesWithVpcGatewayEndpoint(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociateRouteTablesWithVpcGatewayEndpointWithCallback invokes the vpc.AssociateRouteTablesWithVpcGatewayEndpoint API asynchronously
func (client *Client) AssociateRouteTablesWithVpcGatewayEndpointWithCallback(request *AssociateRouteTablesWithVpcGatewayEndpointRequest, callback func(response *AssociateRouteTablesWithVpcGatewayEndpointResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociateRouteTablesWithVpcGatewayEndpointResponse
		var err error
		defer close(result)
		response, err = client.AssociateRouteTablesWithVpcGatewayEndpoint(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociateRouteTablesWithVpcGatewayEndpointRequest is the request struct for api AssociateRouteTablesWithVpcGatewayEndpoint
type AssociateRouteTablesWithVpcGatewayEndpointRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	EndpointId           string           `position:"Query" name:"EndpointId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RouteTableIds        *[]string        `position:"Query" name:"RouteTableIds"  type:"Repeated"`
}

// AssociateRouteTablesWithVpcGatewayEndpointResponse is the response struct for api AssociateRouteTablesWithVpcGatewayEndpoint
type AssociateRouteTablesWithVpcGatewayEndpointResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociateRouteTablesWithVpcGatewayEndpointRequest creates a request to invoke AssociateRouteTablesWithVpcGatewayEndpoint API
func CreateAssociateRouteTablesWithVpcGatewayEndpointRequest() (request *AssociateRouteTablesWithVpcGatewayEndpointRequest) {
	request = &AssociateRouteTablesWithVpcGatewayEndpointRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AssociateRouteTablesWithVpcGatewayEndpoint", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAssociateRouteTablesWithVpcGatewayEndpointResponse creates a response to parse from AssociateRouteTablesWithVpcGatewayEndpoint response
func CreateAssociateRouteTablesWithVpcGatewayEndpointResponse() (response *AssociateRouteTablesWithVpcGatewayEndpointResponse) {
	response = &AssociateRouteTablesWithVpcGatewayEndpointResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
