package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVpcGatewayEndpointAttribute invokes the vpc.GetVpcGatewayEndpointAttribute API synchronously
func (client *Client) GetVpcGatewayEndpointAttribute(request *GetVpcGatewayEndpointAttributeRequest) (response *GetVpcGatewayEndpointAttributeResponse, err error) {
	response = CreateGetVpcGatewayEndpointAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// GetVpcGatewayEndpointAttributeWithChan invokes the vpc.GetVpcGatewayEndpointAttribute API asynchronously
func (client *Client) GetVpcGatewayEndpointAttributeWithChan(request *GetVpcGatewayEndpointAttributeRequest) (<-chan *GetVpcGatewayEndpointAttributeResponse, <-chan error) {
	responseChan := make(chan *GetVpcGatewayEndpointAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVpcGatewayEndpointAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVpcGatewayEndpointAttributeWithCallback invokes the vpc.GetVpcGatewayEndpointAttribute API asynchronously
func (client *Client) GetVpcGatewayEndpointAttributeWithCallback(request *GetVpcGatewayEndpointAttributeRequest, callback func(response *GetVpcGatewayEndpointAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVpcGatewayEndpointAttributeResponse
		var err error
		defer close(result)
		response, err = client.GetVpcGatewayEndpointAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVpcGatewayEndpointAttributeRequest is the request struct for api GetVpcGatewayEndpointAttribute
type GetVpcGatewayEndpointAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	EndpointId           string           `position:"Query" name:"EndpointId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// GetVpcGatewayEndpointAttributeResponse is the response struct for api GetVpcGatewayEndpointAttribute
type GetVpcGatewayEndpointAttributeResponse struct {
	*responses.BaseResponse
	RequestId           string   `json:"RequestId" xml:"RequestId"`
	EndpointId          string   `json:"EndpointId" xml:"EndpointId"`
	EndpointName        string   `json:"EndpointName" xml:"EndpointName"`
	EndpointDescription string   `json:"EndpointDescription" xml:"EndpointDescription"`
	ServiceName         string   `json:"ServiceName" xml:"ServiceName"`
	VpcId               string   `json:"VpcId" xml:"VpcId"`
	PolicyDocument      string   `json:"PolicyDocument" xml:"PolicyDocument"`
	CreationTime        string   `json:"CreationTime" xml:"CreationTime"`
	EndpointStatus      string   `json:"EndpointStatus" xml:"EndpointStatus"`
	RouteTables         []string `json:"RouteTables" xml:"RouteTables"`
}

// CreateGetVpcGatewayEndpointAttributeRequest creates a request to invoke GetVpcGatewayEndpointAttribute API
func CreateGetVpcGatewayEndpointAttributeRequest() (request *GetVpcGatewayEndpointAttributeRequest) {
	request = &GetVpcGatewayEndpointAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "GetVpcGatewayEndpointAttribute", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetVpcGatewayEndpointAttributeResponse creates a response to parse from GetVpcGatewayEndpointAttribute response
func CreateGetVpcGatewayEndpointAttributeResponse() (response *GetVpcGatewayEndpointAttributeResponse) {
	response = &GetVpcGatewayEndpointAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
